/*
** Copyright 1998 - 2004 Double Precision, Inc.  See COPYING for
** distribution information.
*/

#if HAVE_CONFIG_H
#include "courier_auth_config.h"
#endif
#include	<stdio.h>
#include	<stdlib.h>
#include	<ctype.h>
#include	<string.h>
#include	<errno.h>

#include	"auth.h"
#include	"authldap.h"
#include	"authstaticlist.h"
#include	"courierauthdebug.h"

static const char rcsid[]="$Id: authldap.c,v 1.22 2005/03/20 19:10:30 mrsam Exp $";

extern void auth_ldap_enumerate( void(*cb_func)(const char *name,
						uid_t uid,
						gid_t gid,
						const char *homedir,
						const char *maildir,
						const char *options,
						void *void_arg),
				 void *void_arg);

static int auth_ldap_login(const char *service, char *authdata,
			   int (*callback_func)(struct authinfo *, void *),
			   void *callback_arg)
{
	const char *user, *pass;

	if ((user=strtok(authdata, "\n")) == 0 ||
		(pass=strtok(0, "\n")) == 0)
	{
		DPRINTF("incomplete authentication data");
		errno=EPERM;
		return (-1);
	}

	return authldapcommon(service, user, pass, callback_func,
			      callback_arg);
}

#if HAVE_HMACLIB

#include	"libhmac/hmac.h"
#include	"cramlib.h"

static int auth_ldap_cram(const char *service,
			  const char *authtype, char *authdata,
			  int (*callback_func)(struct authinfo *, void *),
			  void *callback_arg)
{
	struct	cram_callback_info	cci;

	if (auth_get_cram(authtype, authdata, &cci))
		return (-1);

	cci.callback_func=callback_func;
	cci.callback_arg=callback_arg;

	return authldapcommon(service, cci.user, 0, &auth_cram_callback, &cci);
}
#endif

int auth_ldap(const char *service, const char *authtype, char *authdata,
	      int (*callback_func)(struct authinfo *, void *),
	      void *callback_arg)
{
	if (strcmp(authtype, AUTHTYPE_LOGIN) == 0)
		return (auth_ldap_login(service, authdata,
			callback_func, callback_arg));

#if HAVE_HMACLIB
	return (auth_ldap_cram(service, authtype, authdata,
			callback_func, callback_arg));
#else
	errno=EPERM;
	return (-1);
#endif
}


extern int auth_ldap_pre(const char *userid, const char *service,
        int (*callback)(struct authinfo *, void *),
		  void *arg);

extern int auth_ldap_changepw(const char *, const char *, const char *,
			      const char *);

static struct authstaticinfo authldap_info={
	"authldap",
	auth_ldap,
	auth_ldap_pre,
	authldapclose,
	auth_ldap_changepw,
	authldapclose,
	auth_ldap_enumerate};


struct authstaticinfo *courier_authldap_init()
{
	return &authldap_info;
}
