
#include "ClamDScan.hpp"
#include "OptionContainer.hpp"
#include <stdio.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/un.h>

extern OptionContainer o;

// Constructor
ClamDScan::ClamDScan()
:virname(NULL),errorMsg(NULL) {};

// Deconstructor
ClamDScan::~ClamDScan() {};

int ClamDScan::dsfile(int sockd, const char *filename) {
    int infected = 0;
    char buff[4096], scancmd[256];
    FILE *fd;
#ifdef DGDEBUG
    std::cout << "Entering dsfile" << std::endl;
#endif

    sprintf(scancmd, "CONTSCAN %s", filename);

#ifdef DGDEBUG
    std::cout << "Before sending clamd command: " << scancmd << std::endl;
#endif

    if(write(sockd, scancmd, strlen(scancmd)) <= 0) {
	// Error writing to clamd socket
	infected = 2;
    }

    // reading response from clamd
    if((fd = fdopen(dup(sockd), "r")) == NULL) {
	// Error opening socket for reading
#ifdef DGDEBUG
	std::cout << "Error opening clamd socket for reading" << std::endl;
#endif
	infected = 2;
	return infected;
    }

    while(fgets(buff, sizeof(buff), fd)) {
	if(strstr(buff, "FOUND\n")) {
	    infected = 1;
	}
	if (strstr(buff, "ERROR\n")) {
	    infected = 2;
	}
    }
#ifdef DGDEBUG
	std::cout << "Got reply from clamd: '" << buff << "'" << std::endl;
#endif

    if (infected == 1) {
	virname = new char[256];
	strcpy(virname, buff);
	virname += (strlen(filename) + 2); // clamd adds " :" to the returning string
	virname[strlen(virname) - 7] = '\0'; // Removing " FOUND\n" from returning string
#ifdef DGDEBUG
	std::cout << "Virus found: '" << virname << "'" << std::endl;
#endif
    }
    else if (infected == 2) {
	errorMsg = new char[256];
	strcpy(errorMsg, buff);
	errorMsg += (strlen(filename) + 2);  // clamd adds " :" to the returning text
	errorMsg[strlen(errorMsg) - 7] = '\0'; // Removing " ERROR\n" from returning string
#ifdef DGDEBUG
	std::cout << "Error found: '" << errorMsg << "'" << std::endl;
#endif
    }
    fclose(fd);
    
    return infected;
}

int ClamDScan::dconnect(void) {

    struct sockaddr_un server;
    int sockd;
    const char *LocalSocket = o.localsocket.c_str();
    
    server.sun_family = AF_UNIX;
    strncpy(server.sun_path, LocalSocket, sizeof(server.sun_path));

    if((sockd = socket(AF_UNIX, SOCK_STREAM, 0)) < 0) {
	return -1;
    }

    if(connect(sockd, (struct sockaddr *) &server, sizeof(struct sockaddr_un)) < 0) {
	return -1;
    }

    return sockd;
}

int ClamDScan::scanFile(const char *filename) {
    int sockd = 0;
    int infected = 0;

#ifdef DGDEBUG
    std::cout << "Entering ClamDScan scanFile" << std::endl;
    std::cout << "Before calling dconnect" << std::endl;
#endif
    if((sockd = dconnect()) < 0) {
#ifdef DGDEBUG
    std::cout << "Error connecting to clamd daemon" << std::endl;
#endif
	infected = 2;
    }
    else {
#ifdef DGDEBUG
    std::cout << "Before calling dsfile" << std::endl;
#endif
	infected = dsfile(sockd, filename);
    }
    close(sockd);

    return infected;
}
