/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jpath.expression;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.jsp.PageContext;
import org.apache.taglibs.standard.lang.jpath.adapter.IterationContext;
import org.apache.taglibs.standard.lang.jpath.expression.EvaluationException;
import org.apache.taglibs.standard.lang.jpath.expression.Introspectable;
import org.apache.taglibs.standard.lang.jpath.expression.Parser;
import org.apache.taglibs.standard.lang.jpath.expression.SimpleNode;

public class Identifier
extends SimpleNode
implements Introspectable {
    protected String val;

    public Identifier(int id) {
        super(id);
    }

    public Identifier(Parser p, int id) {
        super(p, id);
    }

    public String toNormalizedString() {
        return this.val;
    }

    public Object evaluate(PageContext pageContext, IterationContext icontext) throws EvaluationException {
        Object result = pageContext.findAttribute(this.val);
        return result;
    }

    public Object evaluate(PageContext pageContext, IterationContext icontext, int scope) throws EvaluationException {
        Object result = pageContext.getAttribute(this.val, scope);
        return result;
    }

    public Object evaluate(PageContext pageContext, IterationContext icontext, Object parent) throws EvaluationException {
        Object result = null;
        if (parent != null) {
            try {
                PropertyDescriptor pd = this.getFeatureDescriptor(parent.getClass(), this.val);
                if (pd != null) {
                    result = this.getAttribute(pd, parent);
                }
            }
            catch (IntrospectionException ie) {
                throw new EvaluationException(this, "Introspection Exception:" + ie.getMessage());
            }
            catch (NoSuchMethodException nsme) {
                throw new EvaluationException(this, "NoSuchMethodException:" + nsme.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new EvaluationException(this, "IllegalAccessException:" + iae.toString());
            }
            catch (InvocationTargetException ite) {
                throw new EvaluationException(this, "InvocationTargetException:" + ite.getMessage());
            }
        }
        return result;
    }

    private PropertyDescriptor getFeatureDescriptor(Class c, String key) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(c);
        PropertyDescriptor[] pda = beanInfo.getPropertyDescriptors();
        int i = pda.length - 1;
        while (i >= 0) {
            PropertyDescriptor pd = pda[i];
            if (pd.getName().equals(key)) {
                return pd;
            }
            --i;
        }
        return null;
    }

    private Object getAttribute(PropertyDescriptor pd, Object o) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object result = null;
        Method m = pd.getReadMethod();
        m = this.getPublicMethod(m.getDeclaringClass(), m.getName(), m.getParameterTypes());
        result = m.invoke(o, null);
        return result;
    }

    private Method getPublicMethod(Class c, String name, Class[] paramTypes) throws NoSuchMethodException {
        Method result = null;
        if ((c.getModifiers() & 1) == 0) {
            Class sc = c.getSuperclass();
            if (sc != null) {
                try {
                    result = this.getPublicMethod(sc, name, paramTypes);
                }
                catch (NoSuchMethodException nsme) {
                    // empty catch block
                }
            }
            if (result == null) {
                Class<?>[] interfaces = c.getInterfaces();
                int i = 0;
                while (i < interfaces.length) {
                    try {
                        result = this.getPublicMethod(interfaces[i], name, paramTypes);
                    }
                    catch (NoSuchMethodException nsme) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        } else {
            result = c.getMethod(name, paramTypes);
        }
        return result;
    }
}

