\name{getDatasetReference}
\alias{getDatasetReference}
\alias{getDatasetReference.ggobi}
\alias{getDatasetReference.numeric}
\alias{getDatasetReference.ggobiDisplay}
\alias{getDatasetReference.ggobiDisplayDescription}
\alias{getDisplayDataset.ggobi}
\alias{getDatasetReference.ggobiDataset}
\title{Get an object representing an internal ggobi dataset}
\description{
It is convenient to be able to refer to and operate
on a ggobi dataset as if it were a regular S dataset.
 This generic function allows one to get an object that represents a
particular dataset and for which many of the standard methods used to
manipulate data frames, etc. are defined.  The object is of class
\code{ggobiDataset}.  One can derive such an object by index or name,
or from a \code{ggobiDisplay} or its fuller form
\code{ggobiDisplayDescription}.
}
\usage{
getDatasetReference(which, .gobi=getDefaultGGobi())
getDatasetReference.ggobi(which, .gobi=getDefaultGGobi(), simplify = TRUE)
getDatasetReference.numeric(which, .gobi = getDefaultGGobi())
getDatasetReference.ggobiDataset(which, .gobi = getDefaultGGobi()) 
getDatasetReference.ggobiDisplay(which, .gobi=getDefaultGGobi())
getDatasetReference.ggobiDisplayDescription(which, .gobi=getDefaultGGobi())
getDisplayDataset.ggobi(dpy, .gobi=getDefaultGGobi())
}
\arguments{
  \item{which}{an identifier for the particular dataset to be 
   foused to match agains the names of the datasets, or 
  altend within the ggobi instance. This can be a string which 
  is used to match agains the names of the datasets, or 
  alternatively an integer which is used to index into the list
  of the datasets in the ggobi instance.}
  \item{dpy}{an object of class \code{ggobiDisplay} or an integer
    identifying the particular display in the ggobi instance's display list.}
  \item{\dots}{other arguments that allow one to resolve the dataset,
   usually the \code{.gobi} argument.}
  \item{.gobi}{the ggobi instance in which to resolve the
   datgetDatasetReference.ggobiDisplay(which)aset. This should be an object of class \code{ggobi} or an integer identifying
   the instance in the list of all current ggobi instances.}
 \code{simplify}{a logical value indicating whether, if only one dataset
   is returned, to pass it back directly (\code{TRUE}) or leave it as
   the only element within the returned list (\code{FALSE}).
 }
}

\value{
  The result is an object of class \code{ggobiDataset}
 and its contents are meaningless at the S language level.
 They are used only in internal C routines to identify 
 the dataset.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{
 \code{\link{[.ggobi}}
 \code{\link{getDisplays.ggobi}}
}

\examples{
  g <- ggobi(system.file("datasets", "flea.xml", package="Rggobi"), args="-noinit")
  g$setData(system.file("datasets", "sat.xml", package="Rggobi"))

  g[[1]]
  g[["flea"]]

  g[["SAT scores"]]

   # Get reference by index
  g$getDatasetReference(1)
   # by name
  g$getDatasetReference("flea")

   # get it from a ggobiDisplayDescription object
  d <- g$getDisplays(TRUE)[[1]]
  getDatasetReference(d)

   # get it from a ggobiDisplay object
  d <- g$getDisplays()[[1]]
  getDatasetReference(d)
}
\keyword{iplot}
\keyword{dynamic}
