\name{getFileNames.ggobi}
\alias{getFileNames.ggobi}
\title{Identify the files associated with a ggobi instance's data sets.}
\description{
It is often convenient to be able to query the source of
a data set currently in ggobi. When the data is read
from a file, the name of the file or URL is sufficient.
This function returns the name of the primary file from which 
the data was read. 
It can also be asked to return a list of the secondary 
or auxillary files that were read due to a reference
in the primary file.
}
\usage{
getFileNames.ggobi(auxillary = FALSE, .gobi=getDefaultGGobi())
}
\arguments{
  \item{auxillary}{a logical value indicating whether to retur
    the secondary or auxillary files that were read based on a reference
    in the primary or other files.
   }
  \item{.gobi}{the ggobi instance whose data sources are to be queried.}
}

\value{
 A list with an element for each dataset in the ggobi instance.
 If \code{auxillary} is \code{FALSE}, each element is a
 single string giving the name of the primary file containing the data.
 If \code{auxillary} is \code{TRUE}, the list's element is a character
 vector containing all the files read when processing the primary file.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{
\code{\link{getGGobi}}
\code{\link{setData.ggobi}}
}

\examples{
 g <- ggobi(system.file("data", "sat.xml", package="Rggobi"), args="-noinit")
 g$setData(system.file("data", "sat.xml", package="Rggobi"), add=TRUE)

 g$getFileNames()
}
\keyword{dynamic}

