/*
 * Copyright (c) 2002, 2003 Red Hat, Inc. All rights reserved.
 *
 * This software may be freely redistributed under the terms of the
 * GNU General Public License.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Liam Stewart
 * Component of: Visual Explain GUI tool for PostgreSQL - Red Hat Edition
 */

package com.redhat.rhdb.vise;

import java.awt.Dimension;
import javax.swing.JComboBox;

/**
 * A fixed-size JComboBox.
 *
 * @author <a href="mailto:liams@redhat.com">Liam Stewart</a>
 * @version 0.0
 */
public class FixedSizeComboBox extends JComboBox {
	private int width, height;

	/**
	 * Creates a new <code>FixedSizeComboBox</code> instance that
	 * should be <i>width</i> wide and <i>height</i> high.
	 *
	 * @param width an <code>int</code> value
	 * @param height an <code>int</code> value
	 */
	public FixedSizeComboBox(int width, int height)
	{
		this.width = width;
		this.height = height;
	}

	// inherits doc comment
	public Dimension getPreferredSize()
	{
		return new Dimension(width, height);
	}
}// FixedSizeComboBox
