//=============================================================================
/**
 * @file FT_Service_Callbacks.h
 *
 * FT_Service_Callbacks.h,v 1.19 2004/02/04 20:20:21 parsons Exp
 *
 * A concrete FT service callback implementation
 *
 * @author Balachandran Natarajan <bala@cs.wustl.edu>
 */
//=============================================================================

#ifndef TAO_FT_CALLBACKS_H
#define TAO_FT_CALLBACKS_H
#include /**/ "ace/pre.h"

#include "FT_ClientORB_export.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#include "tao/Service_Callbacks.h"
#include "orbsvcs/orbsvcs/FT_CORBA_ORBC.h"

class TAO_Profile;
class TAO_MProfile;
class TAO_ORB_Core;

/**
 * @class TAO_FT_Service_Callbacks
 *
 * @brief A class to dynamically load the FT callback implementations in
 * to the ORB.
 *
 * An implementation of the service callbacks that allows the
 * loading of the FT ORB level library in to the ORB
 */
class TAO_FT_ClientORB_Export TAO_FT_Service_Callbacks : public TAO_Service_Callbacks
{
public:
  /// Constructor
  TAO_FT_Service_Callbacks (TAO_ORB_Core *orb_core);

  /// Dtor
  virtual ~TAO_FT_Service_Callbacks (void);

  /// Check whether <obj> is nil or not. FT spec suggests some
  /// extensions for a CORBA::is_nil () operation.
  virtual CORBA::Boolean object_is_nil (CORBA::Object_ptr obj);

  /// Check for equivalency of the two profiles
  virtual CORBA::Boolean is_profile_equivalent (const TAO_Profile *,
                                                const TAO_Profile *);
  /// Calculate the hash
  virtual CORBA::ULong hash_ft (TAO_Profile *p,
                                CORBA::ULong m);

  /// Check whether we need to raise an exception or go for a
  /// reinvocaton.
  virtual TAO::Invocation_Status raise_comm_failure (
      IOP::ServiceContextList &clist,
      TAO_Profile *profile
      ACE_ENV_ARG_DECL);

  /// Check whether we need to raise an exception or go for a
  /// reinvocaton.
  virtual TAO::Invocation_Status raise_transient_failure (
      IOP::ServiceContextList &clist,
      TAO_Profile *profile
      ACE_ENV_ARG_DECL);

private:

  /// Check whether the right flags are available so that we can issue a
  /// restart.
  CORBA::Boolean restart_policy_check (IOP::ServiceContextList &service_list,
                                       const TAO_Profile *profile);

private:
  /// The ORB core in which we have been activated
  TAO_ORB_Core *orb_core_;

  /// Mutex to protect access to the profile that gets passed along
  /// @@ Lock needs to be removed...
  ACE_Lock* profile_lock_;

  /**
   * A flag that indicates that the primary has already failed. So any
   * more calls to select_profile () should not reset the profile
   * pointer to the primary.
   */
  CORBA::Boolean primary_failed_;

  /**
   * A flag to indicate that a secondary has been selected for
   * invocation. We do this only once in the cycle. When we get there
   * again we dont select a primary again and again.
   */
  CORBA::Boolean secondary_set_;

  /// FT group component in the IOGR
  FT::TagFTGroupTaggedComponent group_component_;

  /// A flag to indicate whether we have extracted the
  /// <group_component> before.
  CORBA::Boolean group_component_flag_;
};

#if defined (__ACE_INLINE__)
# include "FT_Service_Callbacks.inl"
#endif /* __ACE_INLINE__ */

#include /**/ "ace/post.h"
#endif /*TAO_FT_CALLBACKS_H*/
