#!/bin/sh
#
# Validate documentation.
#

file=$1
if [ "$#" -lt 1 ]; then
	echo "Usage: $0 [--noispell] file.xml" >&2
	exit 1
elif [ "$#" -eq 2 ]; then
	noispell=1
	file=$2
fi

lang="`basename $file | sed -e 's/\..*$//' | sed -e 's/^.*_//'`"

if [ ! $noispell ]; then
	echo
	echo "===> spell checking..."
	echo

	ispell -h -d $lang $file
fi

echo
echo "===> validating xml..."
echo

xmllint --noout --valid $file

