//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef CONFIGURATION_GROUPSWIDGET_H
#define CONFIGURATION_GROUPSWIDGET_H

//--------------------
//forward declarations
//--------------------

#include <qiconview.h>
#include <qobject.h>

//=====================================
/*! \brief Displays group icon and text, also contains pointer to widget for setting group settings
 */
//=====================================
class GroupsWidget : public QIconView
{
public:
  GroupsWidget( QWidget* parent=0,
                const char* name = 0 );

  void keyPressEvent( QKeyEvent* e );
  QSize sizeHint() const;
 
  void setTextWidth(int val);
  int getTextWidth();  
  
protected:
  void contentsMousePressEvent ( QMouseEvent * e );
  
private:
  //width allocated to iconview items text.
  //IconViewItems will request this value when running calcRect()
  int textWidth;
};
//======================

#endif //CONFIGURATION_GROUPSWIDGET_H
