//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

//Systemwide includes
#include <qcursor.h>
#include <qpixmap.h>

//Projectwide includes
#include "cursors.h"

//Include cursor xpm's
#include "../../resources/cursors/crossCursor.xpm"

#include "../../resources/cursors/moveSelectionCursor.xpm"
#include "../../resources/cursors/moveHorCursor.xpm"
#include "../../resources/cursors/moveVertCursor.xpm"
#include "../../resources/cursors/moveTLCursor.xpm"
#include "../../resources/cursors/moveTRCursor.xpm"

#include "../../resources/cursors/scaleSelectionCursor.xpm"
#include "../../resources/cursors/rotateCursor.xpm"

#include "../../resources/cursors/targetCursor.xpm"
//==============================================
QCursor** customCursors = new QCursor*[CUSTOM_CURSOR_COUNT];
//==============================================
void loadCursors()
{
  customCursors[CROSS_CURSOR]           = new QCursor( QPixmap( (const char**)crossCursor_xpm));                              

  customCursors[MOVE_SELECTION_CURSOR]  = new QCursor( QPixmap( (const char**)moveSelectionCursor_xpm));                              
  customCursors[MOVE_HOR_CURSOR]        = new QCursor( QPixmap( (const char**)moveHorCursor_xpm));                              
  customCursors[MOVE_VERT_CURSOR]       = new QCursor( QPixmap( (const char**)moveVertCursor_xpm));                              
  customCursors[MOVE_TL_CURSOR]         = new QCursor( QPixmap( (const char**)moveTLCursor_xpm));                              
  customCursors[MOVE_TR_CURSOR]         = new QCursor( QPixmap( (const char**)moveTRCursor_xpm));                              

  customCursors[SCALE_SELECTION_CURSOR] = new QCursor( QPixmap( (const char**)scaleSelectionCursor_xpm));                              
  customCursors[ROTATE_CURSOR]          = new QCursor( QPixmap( (const char**)rotateCursor_xpm));                              

  customCursors[TARGET_CURSOR]          = new QCursor( QPixmap( (const char**)targetCursor_xpm));                              

  customCursors[DEFAULT_CURSOR]         = new QCursor( Qt::ArrowCursor );
}
//===========================================================
const QCursor& getCursor( CUSTOM_CURSOR_TYPE type )
{
  if( type < 0 || type >= CUSTOM_CURSOR_COUNT )
    return *customCursors[DEFAULT_CURSOR];
  else
    return *customCursors[type];
}
//===========================================================
