//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef GUI_PRESENTATION_SLIDESHOWWIDGET_H
#define GUI_PRESENTATION_SLIDESHOWWIDGET_H

//--------------------
//forward declarations
//--------------------
class Album;
class Subalbum;
class Photo;
class QTimer;

#include <qwidget.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qdatetime.h>
#include <qmutex.h>

typedef enum 
{
  AUTO_PLAY,
  IMMEDIATE,
  SCROLL_LEFT,
  SCROLL_RIGHT,
  SCROLL_UP,
  SCROLL_DOWN
} ANIMATION_TYPE;

//=====================================
class SlideshowWidget : public QWidget
{
Q_OBJECT
//----------------------
public:
  SlideshowWidget( QWidget *parent=0, const char* name=0, WFlags f=0 );
  void beginSlideshow(Album* albm, Subalbum* startCollection=NULL, Photo* startPhoto=NULL);

  ///returns a pointer to the currently visible collection
  Subalbum* getCurCollection();
  
  ///returns a pointer to the currently visible photo
  Photo* getCurPhoto();  
  //----------------------
protected:
  void paintEvent( QPaintEvent* );
  void keyPressEvent(QKeyEvent *e);
  void mousePressEvent(QMouseEvent *e);
  void mouseMoveEvent( QMouseEvent *e);
  void contextMenuEvent ( QContextMenuEvent* e );

  void showCoverPage();
  void showCollectionPage(Subalbum* subalbum);
  void loadPhoto();
  void showPhoto();
  void refreshScreen();
  void paintOverlaidControls();
  void exchangePhotos();
//----------------------
signals:
  void endSlideshow();
//----------------------
private slots:
  void animate();
  
  //advance one photo
  void advancePhoto();
  
  //backup one photo
  void backupPhoto();
  
  //skip to first photo in collection
  void skipToFirstPhoto();
  
  //skip to last photo in collection
  void skipToLastPhoto();
  
  //advance one collection
  void advanceCollection();
  
  //backup one collection
  void backupCollection();
  
  //turn off mouse cursor
  void hideMouse();

  //toggle auto play
  void toggleAutoPlay();
  
  //end the slideshow
  void stop();

  //speed up presentation
  void speedUp();
  
  //slow down presentation
  void slowDown();
  
  //increse text font size
  void increaseTextSize();
  
  //decrease text font size
  void decreaseTextSize();
  
  //trap context menu hiding signals and store
  //this info in a bool which disables moving on to the next phot in 
  //respone to a mouse press
  void contextMenuHiding();
//----------------------
private:
  QString themePath;
  Album* curAlbum;
  Subalbum* curCollection;
  Photo* curPhoto;
  
  int photoNum, collectionNum;

  bool photoLoaded;
  
  QImage scaledImage1, scaledImage2;
  QImage* currImage;
  QImage* prevImage;
  
  QImage Top_TextBorder, Bottom_TextBorder,
         Left_TextBorder, Right_TextBorder,
         TL_TextBorder, TR_TextBorder, 
         BL_TextBorder, BR_TextBorder;
  
  //paint buffers
  QPixmap *paintBufferPrev, *paintBufferCurr;
  QPixmap paintBuffer1, paintBuffer2, screenBuffer;
  
  //speed images
  QImage speed1, speed2, speed4, speed8;
  
  //control images
  QImage pauseInterface, playInterface, interfaceAlphaMask;
  
  //full screen size
  int screenWidth, screenHeight;
  
  //specs for ongoing animation
  int lastStep, step;
  double initDelay, minDelay, delay, accel;
  
  //specs for autoplay
  QTimer* autoPlayTimer;
  int autoPlayDelay;
  bool autoPlay;
  bool displayAutoPlayDelay;

  //timer and time variables for ongoing animation
  QTimer *animatingTimer;
  QTime lastTime, currentTime;

  //animating variable and mutex
  bool animating;
  ANIMATION_TYPE type;
  QMutex animatingMutex;
  
  //display debug messages?
  bool displayDebugMessages;
  
  //font size
  int fontSize;
  
  //timer for turning off mouse cursor
  QTimer *mouseCursorTimer;
  bool mouseShown;
  
  //right click context menu
  bool contextMenuShown;
  bool contextMenuHidingBool;
//----------------------
};
//======================

#endif //GUI_PRESENTATION_SLIDESHOWWIDGET_H
