// ---------------------------------------------------------------------------
// - TcpServer.hpp                                                           -
// - aleph:net library - tcp server socket class definition                  -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_TCPSERVER_HPP
#define  ALEPH_TCPSERVER_HPP

#ifndef  ALEPH_TCPSOCKET_HPP
#include "TcpSocket.hpp"
#endif

namespace aleph {

  /// The TcpServer class is an object class used to create a tcp server
  /// object. A server object is created on the local host by specifiying
  /// the port to listen and eventually the backlog number. In the case of
  /// multi-homed host, the server address can also be specified. 
  /// The "accept" method can be used to get a socket object when a
  /// connection is established.
  /// @author amaury darsch

  class TcpServer : public TcpSocket {
  private:
    /// the tcp backlog
    long d_blog;

  public:
    /// create a default tcp server on a ephemeral port
    TcpServer (void);

    /// create a tcp server at specified port
    /// @param port the port to listen
    TcpServer (t_word port);

    /// create a tcp server with a certain backlog
    /// @param port the port to listen
    /// @param backlog the server backlog
    TcpServer (t_word port, const long backlog);

    /// create a tcp server with a host and port
    /// @param host the host to bind the server
    /// @param port the port to listen
    TcpServer (const String& host, t_word port);

    /// create a tcp server with an address and port
    /// @param addr the address to bind the server
    /// @param port the port to listen
    TcpServer (const Address& addr, t_word port);

    /// create a tcp server with a host, port and backlog
    /// @param host the host to bind the server
    /// @param port the port to listen
    /// @param backlog the server backlog
    TcpServer (const String& host, t_word port, const long backlog);

    /// create a tcp server with an address, port and backlog
    /// @param addr the address to bind the server
    /// @param port the port to listen
    /// @param backlog the server backlog
    TcpServer (const Address& addr, t_word port, const long backlog);

    /// @return the class name
    String repr (void) const;

    /// generate a new tcp server
    /// @param argv the argument vector
    static Object* mknew (Vector* argv);

  private:
    // make the copy constructor private
    TcpServer (const TcpServer&);
    // make the assignment operator private
    TcpServer& operator = (const TcpServer&);
  };
}

#endif
