# (c) Aleksey Filutich, 2002        cactus@narod.ru   ICQ#61043410
# (c) Ihar Viarheichyk, 2004		
#
# Tray module (for MS Windows platform only)

if {$::tcl_platform(platform) != "windows"} {
	error "This module can be used in Windows only"
}

package require Winico

# ico resource loader
proc ::load_ico {name file} "
	set [namespace current]::icons(\$name) \[winico createfrom \$file\]
"
proc tray_handler {msg x y} {
  Event Log notice "Event $msg"
  switch -exact -- $msg {
	WM_LBUTTONDOWN {
		focus -force .
	}	
	"WM_LBUTTONDBLCLK" {
     		wm state . [expr ([string equal [wm state .] normal])?"withdrawn":"normal"]
	}	
    	"WM_RBUTTONDOWN" {
		#tree::PopupStatusMenu $x $y
		tk_popup .main.m $x $y
    	} 
  }
}

proc StatusChanged {args} {
  variable icons
  variable tray_icon
  set status [set [ref Me](Status)]
#  set text [encoding convertto [encoding system] "Alicq: [set [ref Me](Alias)] [mc $status]"]
  # Disabled i18n for tray hint, because it works incorrectly with encodings
  set text "Alicq: [set [ref Me](Alias)] $status"
  CleanTray
  winico taskbar add $icons($status) -pos 0 -text $text -callback [nc tray_handler %m %x %y]
  winico setwindow . $icons($status) small 0
  set tray_icon $icons($status)
}

handler exit CleanTray {args} {
  	variable tray_icon
	if {![info exists tray_icon]} return
  	winico taskbar delete $tray_icon
}

# load icons
resource ico {online offline away na dnd ffc occ invisible icq}
winico setwindow . $icons(icq) big
# Hide window instead of deletion
wm protocol . WM_DELETE_WINDOW {wm withdraw .}

StatusChanged
trace variable [ref Me](Status) w [nc StatusChanged]

