'\"
'\" Generated from file '' by tcllib/doctools with format 'nroff'
'\"
.so man.macros
.TH "proxy" n 0.2  "proxy socket connections"
.BS
.SH "NAME"
proxy \- proxy socket connections
.SH "SYNOPSIS"
package require \fBproxy  0.2\fR
.sp
\fBproxy::types\fR \fR
.sp
\fBproxy::enum\fR \fR
.sp
\fBproxy::proxy\fR \fIname\fR ?\fIoptions\fR?\fR
.sp
\fBproxy::connect\fR \fIname\fR \fIserver\fR \fIport\fR \fIscript_ok\fR \fIscript_error\fR ?\fIscript_log\fR?\fR
.sp
\fBproxy::delete\fR \fIname\fR\fR
.sp
.BE
.SH "DESCRIPTION"
The \fBproxy\fR package provides unified interface for using proxies of
different types.
.SH "OPTIONS"
.TP
\fB-type\fR
Type of proxy, for example \fBhttp\fR.
.TP
\fB-server\fR
Proxy server name
.TP
\fB-port\fR
Proxy server port
.TP
\fB-user\fR
User name for authorization. If not given, authorization is not used.
.TP
\fB-password\fR
Password for authentication. If not specified, empty password is used.
.SH "COMMANDS"
.TP
\fBproxy::types\fR \fR
Returns list of proxy types supported at the moment.
.TP
\fBproxy::enum\fR \fR
Returns list of active (created with \fBproxy::proxy\fR command) proxies.
.TP
\fBproxy::proxy\fR \fIname\fR ?\fIoptions\fR?\fR
Creates or confirures existing proxy with given name as identifier.
.TP
\fBproxy::connect\fR \fIname\fR \fIserver\fR \fIport\fR \fIscript_ok\fR \fIscript_error\fR ?\fIscript_log\fR?\fR
Attempts to perform connection to specified \fIserver\fR and \fIport\fR
via active proxy \fIname\fR. \fIscript_ok\fR specifies script which will
be invoked on sucsessfull connection. Additional argument - socket name
will be added to the script when called with \fBeval\fR. \fIscript_error\fR
specifies script which will be invoked on proxy errors. This script should
accept two additional agruments: \fIerror code\fR and
\fIerror description\fR.
\fIerror_log\fR is optional script which is called to log proxy connection.
This command does not return any meaningful value.
.TP
\fBproxy::delete\fR \fIname\fR\fR
Deletes active proxy by name. Returns name of deleted proxy.
.SH "AUTHOR"
Proxy package and this man page was written by Ihar Viarheichyk <iverg@mail.ru>
.SH "KEYWORDS"
proxy, socket
