/* $Id: wmmenuitem.h,v 1.3 2000/11/11 23:41:54 komatsu Exp $ */

#ifndef __WM_MENU_ITEM_H__
#define __WM_MENU_ITEM_H__

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include "wmlabel.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

GtkWidget *wm_menu_item_new_with_wmlabel(WmLabelList *list);

/* $B0J2<$OA4$/$NJLJ*(B ($BJ]N1Cf(B) */

#define WM_MENU_ITEM(obj)          GTK_CHECK_CAST (obj, wm_menu_item_get_type (), WmMenuItem)
#define WM_MENU_ITEM_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, wm_menu_item_get_type (), WmMenuItemClass)
#define IS_WM_MENU_ITEM(obj)       GTK_CHECK_TYPE (obj, wm_menu_item_get_type ())

typedef struct _WmMenuItem        WmMenuItem;
typedef struct _WmMenuItemClass   WmMenuItemClass;

struct _WmMenuItem
{
    GtkMenuItem menu_item;
};

struct _WmMenuItemClass
{
    GtkMenuItemClass parent_class;

    void (* press1)   (WmMenuItem *menu_item);
    void (* press2)   (WmMenuItem *menu_item);
    void (* press3)   (WmMenuItem *menu_item);
    void (* release1) (WmMenuItem *menu_item);
    void (* release2) (WmMenuItem *menu_item);
    void (* release3) (WmMenuItem *menu_item);
};

guint      wm_menu_item_get_type (void);
GtkWidget* wm_menu_item_new(void);
GtkWidget* wm_menu_item_new_with_label(gchar *label);
void wm_menu_item_connect_event(GtkWidget *menu_item, gpointer data);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __WM_MENU_ITEM_H__ */
