/***************************************************************************
 $RCSfile: export.cpp,v $
                             -------------------
    cvs         : $Id: export.cpp,v 1.12 2003/06/14 11:22:42 aquamaniac Exp $
    begin       : Mon May 06 2002
    copyright   : (C) 2002 by Martin Preuss
    email       : martin@aquamaniac.de
*/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

/*
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif



#include "export.h"
#include "xactionmatcher.h"


string _qhacc_dump(const HBCI::Transaction &t, int i) {
    string result;
    list<string>::const_iterator iter;
    HBCI::Value val;
    float fval;
    bool isneg;
    HBCI::Date d;

    // serial num ? for now we use the number
    result+=t.ourAccountId();
    result+="-";
    result+=HBCI::String::num2string(i);
    result+="||";

    // dont know
    result+="0||";

    // num
    result+=HBCI::String::num2string(i);
    result+="||";

    // name
    for (iter=t.otherName().begin();
         iter!=t.otherName().end();
         iter++) {
        if (iter!=t.otherName().begin())
            result+=" ";
        result+=(*iter);
    }
    result+="||";

    // purpose
    for (iter=t.description().begin();
         iter!=t.description().end();
         iter++) {
        if (iter!=t.description().begin())
            result+=" ";
        result+=(*iter);
    }
    result+="||";

    // value
    fval=t.value().getValue();
    isneg=(fval<0);
    val=HBCI::Value(fval,"");
    result+=val.toReadableString();
    result+="||";

    // direction
    if (isneg)
        result+="OUT";
    else
        result+="IN";
    result+="||";

    // date
    if (t.valutaDate().isValid())
        d=t.valutaDate();
    else
        d=t.date();
    result+=HBCI::String::num2string(d.month());
    result+="/";
    result+=HBCI::String::num2string(d.day());
    result+="/";
    result+=HBCI::String::num2string(d.year());

    // that's it
    return result;
}


HBCI::Error export_qhacc(const list<AQMTransaction> &xalist,
			 string fname) {
  HBCI::Error err;
  HBCI::Error err2;
  string result;
  int i;
  HBCI::Pointer<HBCI::File> file;
  list<AQMTransaction>::const_iterator iter;

  // store accounts
  i=1;
  result+="NUMTRANS=";
  result+=HBCI::String::num2string(xalist.size());
  result+="\n";
  for (iter=xalist.begin();
       iter!=xalist.end(); iter++) {
    // dump transaction to file
    result+=_qhacc_dump((*iter),i);
    result+="\n";
    i++;
  } // for transaction data

    // write to file
    file=new HBCI::File(fname);
    err=file.ref().createFile(FILE_AM_RDWR|FILE_AM_CREATE_ALWAYS);
    if (!err.isOk())
        return err;
    err=file.ref().writeData(result);
    err2=file.ref().closeFile();
    if (!err.isOk())
        return err;
    if (!err2.isOk())
        return err2;
    return HBCI::Error();
}


string _txt_dump(const AQMTransaction &t, unsigned int flags) {
  string result;
  list<string>::const_iterator iter;
  HBCI::Date d;
  HBCI::Value val;
  float fval;

  // name
  if (flags&EXPORT_FLAGS_QUOTE)
    result+="\"";
  for (iter=t.otherName().begin();
       iter!=t.otherName().end();
       iter++) {
    if (iter!=t.otherName().begin())
      result+=" ";
    result+=(*iter);
  }
  if (flags&EXPORT_FLAGS_QUOTE)
    result+="\"";
  if (flags&EXPORT_FLAGS_USE_TAB)
    result+=(char)9;
  else
    result+=";";

  // purpose
  if (flags&EXPORT_FLAGS_QUOTE)
    result+="\"";
  for (iter=t.description().begin();
       iter!=t.description().end();
       iter++) {
    if (iter!=t.description().begin())
      result+=" ";
    result+=(*iter);
  }
  if (flags&EXPORT_FLAGS_QUOTE)
    result+="\"";
  if (flags&EXPORT_FLAGS_USE_TAB)
    result+=(char)9;
  else
    result+=";";

  // value
  if (flags&EXPORT_FLAGS_QUOTE)
    result+="\"";
  fval=t.value().getValue();
  val=HBCI::Value(fval,"");
  result+=val.toReadableString();
  if (flags&EXPORT_FLAGS_QUOTE)
    result+="\"";
  if (flags&EXPORT_FLAGS_USE_TAB)
    result+=(char)9;
  else
    result+=";";

  // currency
  if (flags&EXPORT_FLAGS_QUOTE)
    result+="\"";
  result+=t.value().getCurrency();
  if (flags&EXPORT_FLAGS_QUOTE)
    result+="\"";
  if (flags&EXPORT_FLAGS_USE_TAB)
    result+=(char)9;
  else
    result+=";";

  // date
  if (flags&EXPORT_FLAGS_QUOTE)
    result+="\"";
  if (t.valutaDate().isValid())
    d=t.valutaDate();
  else
    d=t.date();
  result+=HBCI::String::num2string(d.day());
  result+=".";
  result+=HBCI::String::num2string(d.month());
  result+=".";
  result+=HBCI::String::num2string(d.year());
  if (flags&EXPORT_FLAGS_QUOTE)
    result+="\"";
  if (flags&EXPORT_FLAGS_USE_TAB)
    result+=(char)9;
  else
    result+=";";

  // text
  if (flags&EXPORT_FLAGS_QUOTE)
    result+="\"";
  result+=t.transactionText();
  if (flags&EXPORT_FLAGS_QUOTE)
    result+="\"";
  if (flags&EXPORT_FLAGS_USE_TAB)
    result+=(char)9;
  else
    result+=";";

  // transaction id
  if (flags&EXPORT_FLAGS_QUOTE)
    result+="\"";
  result+=HBCI::String::num2string(t.id());
  if (flags&EXPORT_FLAGS_QUOTE)
    result+="\"";

  // that's it
  return result;
}


HBCI::Error export_txt(const list<AQMTransaction> &xalist,
		       const string &fname,
		       unsigned int flags,
		       const HBCI::Date &fromdate,
		       const HBCI::Date &todate){
  HBCI::Error err;
  HBCI::Error err2;
  string result;
  int i;
  HBCI::Pointer<HBCI::File> file;
  list<AQMTransaction>::const_iterator iter;
  TransactionMatcher tm;

  tm=TransactionMatcher(0,
			"*",
			"*",
			fromdate,
			todate,
			flags & 0xffff);

  // export accounts
  if (flags&EXPORT_FLAGS_HEADER) {
    if (flags&EXPORT_FLAGS_QUOTE)
      result+="\"";
    result+="Name";
    if (flags&EXPORT_FLAGS_QUOTE)
      result+="\"";
    if (flags&EXPORT_FLAGS_USE_TAB)
      result+=(char)9;
    else
      result+=";";

    if (flags&EXPORT_FLAGS_QUOTE)
      result+="\"";
    result+="Verwendungszweck";
    if (flags&EXPORT_FLAGS_QUOTE)
      result+="\"";
    if (flags&EXPORT_FLAGS_USE_TAB)
      result+=(char)9;
    else
      result+=";";

    if (flags&EXPORT_FLAGS_QUOTE)
      result+="\"";
    result+="Betrag";
    if (flags&EXPORT_FLAGS_QUOTE)
      result+="\"";
    if (flags&EXPORT_FLAGS_USE_TAB)
      result+=(char)9;
    else
      result+=";";

    if (flags&EXPORT_FLAGS_QUOTE)
      result+="\"";
    result+="Waehrung";
    if (flags&EXPORT_FLAGS_QUOTE)
      result+="\"";
    if (flags&EXPORT_FLAGS_USE_TAB)
      result+=(char)9;
    else
      result+=";";
    if (flags&EXPORT_FLAGS_QUOTE)
      result+="\"";
    result+="Datum\n";
    if (flags&EXPORT_FLAGS_QUOTE)
      result+="\"";
  } // if header

  for (iter=xalist.begin();
       iter!=xalist.end(); iter++) {
    // dump transaction to string
    if (!tm.match(*iter))
      continue;
    result+=_txt_dump((*iter), flags);
    result+="\n";
    i++;
  } // for transaction data

  // write to file or stdout
  if (fname=="-") {
    fprintf(stdout, "%s", result.c_str());
  }
  else {
    file=new HBCI::File(fname);
    err=file.ref().createFile(FILE_AM_RDWR|FILE_AM_CREATE_ALWAYS);
    if (!err.isOk())
      return err;
    err=file.ref().writeData(result);
    err2=file.ref().closeFile();
    if (!err.isOk())
      return err;
    if (!err2.isOk())
      return err2;
  }
  return HBCI::Error();
}




HBCI::Error texport(HBCI::Pointer<AQMAPI> hbciif,
		    HBCI::SimpleConfig &opt){
  HBCI::cfgPtr var;
  int country;
  string instid;
  string accnr;
  list<HBCI::Pointer<HBCI::Account> > acclist;
  list<HBCI::Pointer<HBCI::Account> >::const_iterator it;
  HBCI::Error err;
  HBCI::Error err2;
  string result;
  string fname;
  string tmp;
  string format;
  unsigned int flags=0;
  HBCI::Date fromdate;
  HBCI::Date todate;

  country=opt.getIntVariable("country",0,opt.root());
  instid=opt.getVariable("instid","*",opt.root());
  accnr=opt.getVariable("accnr","*",opt.root());
  fname=opt.getVariable("outfile","-",opt.root());
  format=opt.getVariable("outformat","",opt.root());
  fromdate=opt.getVariable("fromdate","",opt.root());
  todate=opt.getVariable("todate","",opt.root());

  flags|=TM_FLAGS_POSITIVE;
  flags|=TM_FLAGS_NEGATIVE;
  flags|=EXPORT_FLAGS_QUOTE;
  flags|=EXPORT_FLAGS_HEADER;
  if (opt.findVariable("pos",opt.root(),false).isValid())
    flags&=~TM_FLAGS_NEGATIVE;
  if (opt.findVariable("neg",opt.root(),false).isValid())
    flags&=~TM_FLAGS_POSITIVE;
  if (opt.findVariable("tab",opt.root(),false).isValid())
    flags|=EXPORT_FLAGS_USE_TAB;
  if (opt.findVariable("noquote",opt.root(),false).isValid())
    flags&=~EXPORT_FLAGS_QUOTE;
  if (opt.findVariable("noheader",opt.root(),false).isValid())
    flags&=~EXPORT_FLAGS_HEADER;

  if (opt.findVariable("transfers",opt.root(),false).isValid()) {
    flags|=EXPORT_FLAGS_TRANSFERS;
    if (opt.findVariable("open",opt.root(),false).isValid())
      flags|=TM_FLAGS_OPEN;
    if (opt.findVariable("failed",opt.root(),false).isValid())
      flags|=TM_FLAGS_FAILED;
    if (opt.findVariable("done",opt.root(),false).isValid())
      flags|=TM_FLAGS_DONE;
    if (opt.findVariable("nounknown",opt.root(),false).isValid())
      flags|=TM_FLAGS_NO_UNKNOWN;

    if ((flags & (TM_FLAGS_OPEN |
		  TM_FLAGS_FAILED |
		  TM_FLAGS_DONE))==0)
      flags|=(TM_FLAGS_OPEN |
	      TM_FLAGS_FAILED |
	      TM_FLAGS_DONE);
  }

  if (fname.empty())
    return HBCI::Error("texport()",
		       ERROR_LEVEL_NORMAL,
		       0,
		       ERROR_ADVISE_DONTKNOW,
		       "name of output file needed.");
  if (format.empty())
    return HBCI::Error("texport()",
		       ERROR_LEVEL_NORMAL,
		       0,
		       ERROR_ADVISE_DONTKNOW,
		       "name of output format needed.");

  // get accounts
  acclist=hbciif.ref().getAccounts(country,instid,accnr);
  if (acclist.empty())
    return HBCI::Error("texport()",
		       ERROR_LEVEL_NORMAL,
		       0,
		       ERROR_ADVISE_DONTKNOW,
		       "no account found.");

  // if no data then simply return
  if (flags & EXPORT_FLAGS_TRANSFERS) {
    fprintf(stderr, "Exporting transfers.\n");
    if (format=="qhacc")
      err=export_qhacc(hbciif.ref().transfers(),fname);
    else if (format=="txt")
      err=export_txt(hbciif.ref().transfers(),fname,
		     flags,
		     fromdate,
		     todate);
    else
      err=HBCI::Error("texport()",
		      ERROR_LEVEL_NORMAL,
		      0,
		      ERROR_ADVISE_DONTKNOW,
		      "unknown output format.");
  }
  else {
    for (it=acclist.begin();
	 it!=acclist.end();
	 it++) {
      if (!(*it).ref().transactions().empty()) {
	// output
	list<AQMTransaction> xalist;
	list<HBCI::Transaction>::const_iterator xit;

	for (xit=(*it).ref().transactions().begin();
	     xit!=(*it).ref().transactions().end();
	     xit++)
	  xalist.push_back(AQMTransaction(*xit));
	if (format=="qhacc")
	  err=export_qhacc(xalist,fname);
	else if (format=="txt")
	  err=export_txt(xalist,fname,
			 flags,
			 fromdate,
			 todate);
	else
	  err=HBCI::Error("texport()",
			  ERROR_LEVEL_NORMAL,
			  0,
			  ERROR_ADVISE_DONTKNOW,
			  "unknown output format.");
      }
      if (!err.isOk())
	return err;
    } // if transactions
  } // for

  return HBCI::Error();
}





