/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __DEVICE_H__
#define __DEVICE_H__

#include <qmap.h>

/*========================================================*/

class ArsonDevice
{
public:
	ArsonDevice (const char *dev = NULL, int devType = DT_UNSPEC)
		: m_dev(dev), m_devType(devType) { }

   enum {
       DT_UNSPEC,
       DT_IOCTLDEV,
       DT_SCSIDEV,
       DT_IDEDEV
   };

   const QCString &dev (void) const { return m_dev; }
	void setDev (const char *dev) { m_dev = dev; }
   int devType (void) const { return m_devType; }
   void setDevType (int devType) { m_devType = devType; }

	virtual const QCString id (void) const { return QCString(); }
	virtual void setId (const char *id) { }
	virtual bool scsiDevice (void) const { return false; }
   virtual bool ideDevice (void) const { return false; }

	virtual QString description (void) const;
	virtual QString display (void) const;

private:
	QCString m_dev;
   int m_devType;
};

/*========================================================*/

class ArsonScsiDevice : public ArsonDevice
{
public:
	ArsonScsiDevice (const char *id = NULL, const char *make = NULL,
		const char *model = NULL, const char *ver = NULL,
		const char *type = NULL);

	virtual const QCString id (void) const { return m_id; }
	virtual void setId (const char *id) { m_id = id; }
	virtual bool scsiDevice (void) const { return true; }
	virtual bool ideDevice (void) const { return false; }

	virtual QString description (void) const;
	virtual QString display (void) const;

private:
	QCString m_id;
	QCString m_make;
	QCString m_model;
	QCString m_version;
	QCString m_type;
};

/*========================================================*/

class ArsonIdeDevice : public ArsonDevice
{
public:
	ArsonIdeDevice (const char *id = NULL, const char *make = NULL,
		const char *model = NULL, const char *type = NULL);

	virtual const QCString id (void) const { return m_id; }
	virtual void setId (const char *id) { m_id = id; }
	virtual bool ideDevice (void) const { return true; }
	virtual bool scsiDevice (void) const { return false; }

	virtual QString description (void) const;
	virtual QString display (void) const;

private:
	QCString m_id;
	QCString m_make;
	QCString m_model;
	QCString m_type;
};

/*========================================================*/

class ArsonDeviceList;
class QComboBox;

class ArsonDeviceUiList
{
public:
	ArsonDeviceUiList (void) : m_devs(NULL) { }
	ArsonDeviceUiList (const QStringList &sl, const ArsonDeviceList *pd);

	const QStringList &keys (void) const { return m_keys; }
	
	void fillList (QComboBox *pl, const char *sel) const;
	QCString fromList (QComboBox *pl) const;

private:
	const ArsonDeviceList *m_devs;
	QStringList m_keys;
};

/*========================================================*/

class KConfig;

class ArsonDeviceList
{
	typedef QMap<QCString,ArsonDevice*> DEVICES;

public:
   
	ArsonDeviceList (void);
	ArsonDeviceList (const ArsonDeviceList &obj);	
	~ArsonDeviceList (void);

	ArsonDeviceList &operator= (const ArsonDeviceList &obj);

	bool addIoctlDev (const char *dev);
	bool delIoctlDev (const char *dev);

	ArsonDeviceUiList uiList () const;
	ArsonDeviceUiList uiList (int onlyDevType) const;

	QStringList keys (void) const;
	void clear (void);

	uint count (void) const { return m_devs.count(); }
	uint ioctlCount (void) const { return count(ArsonDevice::DT_IOCTLDEV); }
	uint scsiCount (void) const { return count(ArsonDevice::DT_SCSIDEV); }
	uint ideCount (void) const { return count(ArsonDevice::DT_IDEDEV); }

	const ArsonDevice *device (const char *dev) const;
	ArsonDevice *device (const char *dev);

	int scanbus (void);

	void load (KConfig *pk);
	void save (KConfig *pk);
	
private:
   int scanScsiBus (void);
   int scanIdeBus (void);
	void addDev (const char *dev, ArsonDevice *ptr);
	void delDev (const char *dev);
	uint count (int type) const;
	void clear (int type);

	DEVICES m_devs;
};

/*========================================================*/
#endif	/*	__DEVICE_H__	*/
