/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import nz.net.catalyst.ELog;
import nz.net.catalyst.Log;
import nz.net.catalyst.StringPair;
import nz.net.catalyst.Util;
import nz.net.catalyst.lucene.server.Application;
import nz.net.catalyst.lucene.server.ApplicationMissingException;
import nz.net.catalyst.lucene.server.Constants;
import nz.net.catalyst.lucene.server.DateField;
import nz.net.catalyst.lucene.server.ECommand;
import nz.net.catalyst.lucene.server.FieldDef;
import nz.net.catalyst.lucene.server.IPackage;
import nz.net.catalyst.lucene.server.Transmission;
import nz.net.catalyst.lucene.server.WriterControl;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;

public class Index
implements IPackage,
Constants {
    private static final Set SPECIAL_HEADERS = new HashSet();
    private final Transmission input;
    private Application application;
    private String domain;
    private String id;

    static {
        SPECIAL_HEADERS.add("Id");
        SPECIAL_HEADERS.add("Domain");
        SPECIAL_HEADERS.add("Application");
        SPECIAL_HEADERS.add("Stop-List");
        SPECIAL_HEADERS.add("Field-Name");
        SPECIAL_HEADERS.add("Field-Type");
        SPECIAL_HEADERS.add("Field-Indexed");
        SPECIAL_HEADERS.add("Field-Stored");
        SPECIAL_HEADERS.add("Content-Length");
        SPECIAL_HEADERS.add("Body");
        SPECIAL_HEADERS.add("Serial");
    }

    Index(Transmission transmission) {
        this.input = transmission;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Transmission execute() {
        Transmission response;
        block35: {
            long afterReaderClose;
            long indexStart = System.currentTimeMillis();
            response = new Transmission(ECommand.INDEX_RESPONSE);
            response.setSerial(this.input.getSerial());
            this.id = this.input.get("Id", Constants.NO_APP);
            if (this.id == null) {
                return this.error("Mandatory 'Id' header is missing");
            }
            String appName = this.input.get("Application", Constants.NO_APP);
            try {
                this.application = Application.getAppOrDefault(appName);
            }
            catch (ApplicationMissingException e) {
                return this.error(e.getMessage());
            }
            this.input.setApplication(this.application);
            this.domain = this.input.get("Domain");
            if (this.domain == null) {
                return this.error("'Domain' header is missing and is not in Application defaults");
            }
            Analyzer analyzer = Application.getAnalyzer(this.input);
            List fields = this.input.getFields();
            File luceneStoreDir = Application.getIndexDirectory(this.application);
            Document document = this.createDocument(fields);
            boolean succeed = false;
            long beforeLock = System.currentTimeMillis();
            boolean create = false;
            if (!luceneStoreDir.isDirectory()) {
                luceneStoreDir.mkdirs();
                if (!luceneStoreDir.isDirectory()) {
                    return this.error("Cannot access Lucene Index in directory: " + luceneStoreDir.getPath());
                }
                create = true;
            }
            long afterDelete = afterReaderClose = System.currentTimeMillis();
            long afterReaderOpen = afterReaderClose;
            WriterControl writerControl = null;
            String stage = "";
            try {
                try {
                    if (!create) {
                        block33: {
                            IndexReader reader = null;
                            succeed = false;
                            stage = "opening IndexReader";
                            try {
                                try {
                                    writerControl = WriterControl.closeWriter(luceneStoreDir, true);
                                    reader = IndexReader.open((File)luceneStoreDir);
                                    afterReaderOpen = System.currentTimeMillis();
                                    Term keyField = new Term("\u0000Domain\u0000Id", String.valueOf(this.domain) + "\u0000" + this.id);
                                    int count = reader.delete(keyField);
                                    afterDelete = System.currentTimeMillis();
                                    Log.debug("Deleted " + count + " documents");
                                    succeed = true;
                                }
                                catch (FileNotFoundException e) {
                                    Log.debug("Maybe the index is brand new and contains no files!");
                                    Log.log(ELog.ERROR, e.toString());
                                }
                                catch (IOException e) {
                                    Transmission transmission;
                                    block32: {
                                        String message = "Error while deleting previous document Domain=" + this.domain + ", " + "Id" + '=' + this.id + ": " + e.toString();
                                        Log.log(ELog.ERROR, message);
                                        transmission = this.error(message);
                                        Object var30_27 = null;
                                        if (reader != null) {
                                            try {
                                                reader.close();
                                            }
                                            catch (Throwable e2) {
                                                String message2 = "Error while closing IndexReader: " + e2.toString();
                                                Log.log(ELog.ERROR, message2);
                                                if (!succeed) break block32;
                                                Transmission transmission2 = this.error(message2);
                                                Object var35_40 = null;
                                                if (writerControl == null) return transmission2;
                                                try {
                                                    writerControl.release();
                                                    return transmission2;
                                                }
                                                catch (Throwable e3) {
                                                    String message3 = "Error while closing IndexWriter: " + e3.toString();
                                                    Log.log(ELog.ERROR, message3);
                                                    if (!succeed) return transmission2;
                                                    return this.error(message3);
                                                }
                                            }
                                        }
                                    }
                                    Object var35_41 = null;
                                    if (writerControl == null) return transmission;
                                    try {
                                        writerControl.release();
                                        return transmission;
                                    }
                                    catch (Throwable e3) {
                                        String message3 = "Error while closing IndexWriter: " + e3.toString();
                                        Log.log(ELog.ERROR, message3);
                                        if (!succeed) return transmission;
                                        return this.error(message3);
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                Object var30_28 = null;
                                if (reader == null) throw throwable;
                                try {
                                    reader.close();
                                    throw throwable;
                                }
                                catch (Throwable e2) {
                                    String message2 = "Error while closing IndexReader: " + e2.toString();
                                    Log.log(ELog.ERROR, message2);
                                    if (!succeed) throw throwable;
                                    Transmission transmission = this.error(message2);
                                    Object var35_42 = null;
                                    if (writerControl == null) return transmission;
                                    try {
                                        writerControl.release();
                                        return transmission;
                                    }
                                    catch (Throwable e3) {
                                        String message3 = "Error while closing IndexWriter: " + e3.toString();
                                        Log.log(ELog.ERROR, message3);
                                        if (!succeed) return transmission;
                                        return this.error(message3);
                                    }
                                }
                            }
                            Object var30_29 = null;
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable e2) {
                                    String message2 = "Error while closing IndexReader: " + e2.toString();
                                    Log.log(ELog.ERROR, message2);
                                    if (!succeed) break block33;
                                    Transmission transmission = this.error(message2);
                                    Object var35_43 = null;
                                    if (writerControl == null) return transmission;
                                    try {
                                        writerControl.release();
                                        return transmission;
                                    }
                                    catch (Throwable e3) {
                                        String message3 = "Error while closing IndexWriter: " + e3.toString();
                                        Log.log(ELog.ERROR, message3);
                                        if (!succeed) return transmission;
                                        return this.error(message3);
                                    }
                                }
                            }
                        }
                        afterReaderClose = System.currentTimeMillis();
                    }
                    succeed = false;
                    stage = "opening IndexWriter";
                    writerControl = WriterControl.getWriterControl(luceneStoreDir, analyzer);
                    IndexWriter writer = writerControl.getIndexWriter();
                    long afterWriterOpen = System.currentTimeMillis();
                    stage = "adding document";
                    writer.addDocument(document);
                    long afterIndex = System.currentTimeMillis();
                    succeed = true;
                    stage = "";
                }
                catch (IOException e) {
                    String message = "Error while " + stage + ", " + "Domain" + '=' + this.domain + ", " + "Id" + '=' + this.id + ": " + e.toString();
                    Log.log(ELog.ERROR, message);
                    Transmission transmission = this.error(message);
                    Object var35_44 = null;
                    if (writerControl == null) return transmission;
                    try {
                        writerControl.release();
                        return transmission;
                    }
                    catch (Throwable e3) {
                        String message3 = "Error while closing IndexWriter: " + e3.toString();
                        Log.log(ELog.ERROR, message3);
                        if (!succeed) return transmission;
                        return this.error(message3);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var35_45 = null;
                if (writerControl == null) throw throwable;
                try {
                    writerControl.release();
                    throw throwable;
                }
                catch (Throwable e3) {
                    String message3 = "Error while closing IndexWriter: " + e3.toString();
                    Log.log(ELog.ERROR, message3);
                    if (!succeed) throw throwable;
                    return this.error(message3);
                }
            }
            Object var35_46 = null;
            if (writerControl != null) {
                try {
                    writerControl.release();
                }
                catch (Throwable e3) {
                    String message3 = "Error while closing IndexWriter: " + e3.toString();
                    Log.log(ELog.ERROR, message3);
                    if (!succeed) break block35;
                    return this.error(message3);
                }
            }
        }
        long afterWriterClose = System.currentTimeMillis();
        response.add("Status", "Document indexed successfully");
        return response;
    }

    private Document createDocument(List fields) {
        Document document = new Document();
        document.add(Field.Keyword((String)"\u0000Domain\u0000Id", (String)(String.valueOf(this.domain) + "\u0000" + this.id)));
        HashSet<String> processed = new HashSet<String>();
        Iterator it = fields.iterator();
        while (it.hasNext()) {
            String value;
            FieldDef field = (FieldDef)it.next();
            if (field.name.equals("Id")) {
                value = this.id;
            } else if (field.name.equals("Domain")) {
                value = this.domain;
            } else {
                value = this.input.get(field.name);
                if (value == null) continue;
            }
            Log.debug("Adding predefined field \"" + field.name + "\" to document: Value is: \"" + Util.clean(value) + '\"');
            processed.add(field.name);
            if (field.date) {
                try {
                    value = DateField.dateToString(Application.makeDate(value));
                    Log.debug("  =" + value);
                }
                catch (IllegalArgumentException e) {
                    Log.log(ELog.ERROR, "Can't parse \"" + field.name + '=' + value + "\" as a date");
                    continue;
                }
            }
            document.add(new Field(field.name, value, field.store, field.index, field.token));
        }
        it = this.input.getHeadersView().iterator();
        while (it.hasNext()) {
            StringPair header = (StringPair)it.next();
            String key = header.getKeyString();
            if (SPECIAL_HEADERS.contains(key) || processed.contains(key)) continue;
            FieldDef field = new FieldDef(key);
            String value = this.input.get(field.name);
            Log.debug("Adding undefined field \"" + field.name + "\" to document");
            processed.add(field.name);
            document.add(new Field(field.name, value, field.store, field.index, field.token));
        }
        return document;
    }

    private Transmission error(String message) {
        Transmission response = new Transmission(ECommand.INDEX_RESPONSE);
        response.setSerial(this.input.getSerial());
        response.add("Error", message);
        return response;
    }
}

