/** *********************************************************************
 * Copyright (C) 2003 Catalyst IT                                       *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to:                           *
 *   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    *
 *   Boston, MA  02111-1307  USA                                        *
 ************************************************************************/
 package nz.net.catalyst.lucene.testclient;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;

/**
 * This class contains basic scripts for testing the XML part of the
 * LuceneServer.
 * 
 * @author  hamish
 */
public class SocketTestXML {
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) throws java.lang.Exception {
        long tStart = System.currentTimeMillis();
        long tOpenedConnection = 9999L;
        long tAfterExecuting   = 9999L;
        long tClosedConnection = 9999L;
        
        Socket echoSocket = null;
        PrintWriter out = null;
        BufferedReader in = null;

        try {
            echoSocket = new Socket("localhost", 22222);
        	//echoSocket = new Socket("192.168.4.20", 22222); //production
            //echoSocket = new Socket("192.168.4.20", 22223); //staging/test
            //echoSocket = new Socket("192.168.4.20", 22224); //development
            out = new PrintWriter(echoSocket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(
                                        echoSocket.getInputStream()));
        } catch (java.net.UnknownHostException e) {
            System.err.println("Unknown Host Exception. Cannot resolve host.");
            System.exit(1);
        } catch (java.io.IOException e) {
            System.err.println("Couldn't get I/O for the connection.");
            System.exit(1);
        }

        tOpenedConnection = System.currentTimeMillis();

		String index =  "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" +
					   	"<LuceneRequest type=\"INDEX\">" +
					   	"<Application>sos</Application>" +
					   	"<Domain>sos2</Domain>" +
					   	"<Id>zz12</Id>" +
					   	"<Name>cat</Name>" +
					   	"<Details>none</Details>" +
					   	"<Teaser>Buy Me!</Teaser>" +
					   	"<Location>10</Location>" +
					   	"<Category>10</Category>" +
					   	"<DisplayStartDate>2002-12-10</DisplayStartDate>" +
					   	"<SaleStartDate>2002-12-10</SaleStartDate>" +
					   	"<EndDate>2002-12-25</EndDate>" +
					   	"<Cancelled>N</Cancelled>" +
					   	"</LuceneRequest>\n\n";

		String query = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" +
				    	"<LuceneRequest type=\"QUERY\">" +
				    	"<Application>sos</Application>" +
				    	"<Query>" +
				    		"Name:cat\n" +
				    	"</Query>" +
				    	"<Limit>3</Limit>" +
				    	"</LuceneRequest>";

		String optimize = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" +
						  "<LuceneUtilityRequest>" +
			"<Serial>123abc</Serial>" + 
			"<Utility>OPTIMIZE</Utility>" +
			"<Application>newsquest</Application>" +
		"</LuceneUtilityRequest>";

		String backup = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" +
						  "<LuceneUtilityRequest>"                 +
			 			    "<Serial>123abc</Serial>"              + 
			                "<Utility>BACKUP</Utility>"            +
			                "<Application>nqst</Application>"      +
			                "<BackUpTarget>c:\\indexnew</BackUpTarget>"      +
		                  "</LuceneUtilityRequest>";

		String experimental = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" +
						  "<LuceneUtilityRequest>"                 +
							"<Serial>123abc</Serial>"              + 
							"<Utility>EXPERIMENTAL</Utility>"            +
							"<Application>nqst</Application>"      +
						  "</LuceneUtilityRequest>";

				    	
		String old = "QUERY\nApplication:sos\nQuery: Name:cat\nLimit:0\nEND\n";

        String command = backup; 
        
        System.out.println("About to send XML command to server...");
    	System.out.println("===================================================");        
		//send command to server.
        out.println(command);
                        
        String serverOutput;
        java.io.BufferedReader br = new java.io.BufferedReader(in);
        while ( (serverOutput = br.readLine()) != null ) System.out.println("from server: " + serverOutput);
        
        if (serverOutput != null) System.out.println("from server: " + serverOutput);
       
        tAfterExecuting = System.currentTimeMillis();
        
		out.close();
        br.close();
		in.close();
		echoSocket.close();
        
        tClosedConnection = System.currentTimeMillis();
        
        System.out.println("================= Time Statistics =================");
        System.out.println(" Opening Connection: " + (tOpenedConnection - tStart));
        System.out.println(" Executing:          " + (tAfterExecuting - tOpenedConnection));
        System.out.println(" Closing Connection: " + (tClosedConnection - tAfterExecuting));
        System.out.println("===================================================");
        
    }
}
