#! /bin/sh
#
# Remove an Apache Virtual Host config for Axyl.
# NOTE: this is a utility script and does not reload apache
# or restart it after the changes have been made. Nor, does
# it make any backup of the original file.
# P Waite
set -e

# Name of this script
THIS=`basename $0`

# Get common funcs and config vars etc.
# Acquire the local configuration..
CONFDIR=/etc/axyl
CONF=${CONFDIR}/axyl.conf
if [ ! -f $CONF ]
then
  echo "Axyl configuration file $CONF not found!"
  exit 2
else
  . $CONF
  if [ ! -d $AXYL_HOME ] ; then
    echo "FATAL: the Axyl root directory '$AXYL_HOME' does not exist."
    exit 6
  fi
  . ${AXYL_HOME}/install/axyl-common.sh
fi

# Parameters..
if [ $# -lt 1 ]
then
  echo "usage: $THIS servername [silent]"
  exit 3
fi
VSERVERNAME=$1
if [ "$2" != "" ]
then
  MODE=$2
else
  MODE="interactive"
fi

# Files..
apache_reload=0
CONF=${APACHE_CONFDIR}/httpd.conf
if [ -e $CONF ]
then
  # New format or old?
  if [ -e ${APACHE_CONFDIR}/conf.d ]
  then
    CONF=${APACHE_CONFDIR}/conf.d/${VSERVERNAME}.conf
    if [ -w $CONF ]
    then
      tell "removing $CONF"
      rm -f $CONF
      apache_reload=1
    fi
  else
    tell "removing embedded vhost $VSERVERNAME"
    APACHE_CONF_TMP=/tmp/$$.httpd.conf.vhremove
    ${AXYL_HOME}/install/remove-apache-vh.pl $CONF $APACHE_CONF_TMP $VSERVERNAME $MODE
    if [ -e $APACHE_CONF_TMP ]
    then
      mv $APACHE_CONF_TMP $CONF
      apache_reload=1
    else
      tell "$THIS: a virtual host for $VSERVERNAME was not found."
    fi
  fi
else
  tell "$THIS: apache does not seem to be installed."
  exit 7
fi

# END