<?php
/************************************************************************/
/* CATALYST Php  Source Code                                            */
/* Copyright (C)2002 Catalyst IT Limited                                */
/*                                                                      */
/* Filename:    axyl-media-viewer.php                                   */
/* Author:      Paul Waite                                              */
/* Date:        march 2005                                              */
/* Description: Media viewer window. Used to display media in a         */
/*              small popup window. This viewer will auto-size the      */
/*              window if the content is an image. For this to work     */
/*              the image must be inside a 'plain' templated page, ie.  */
/*              it must be the only (first) image on the page.          */
/*                                                                      */
/************************************************************************/
include_once("application.php");

// -----------------------------------------------------------------------------------------------
// PAGE PARAMETERS
// $sid       -  Required. Catalog ID, int4, identifies media to show

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page("Media Viewer", "plain", $theme);

// -----------------------------------------------------------------------
// Site-specific content..
include_once("site-webpage.php");
include_once("catalog-defs.php");

//debug_on(DBG_TRACE|DBG_SQL|DBG_DIAGNOSTIC);

// -----------------------------------------------------------------------------------------------
// AUTHORISATION and SANITY CHECKS

if (!isset($cat_id)) {
  $RESPONSE->send_errorcode_and_die(403);
}

// SHOW STORY..
$catitem = new catalogitem($cat_id);
if (!$catitem->valid) {
  $RESPONSE->send_errorcode_and_die(404);
}

$RESPONSE->head->set_title($catitem->cat_name);
if ($catitem->mime_category == "image") {
  $RESPONSE->add_script(
        "ie5=false; nn4=false; nn6=false;\n"
      . "if(document.all) ie5=true;\n"
      . "else if(document.getElementById) nn6=true;\n"
      . "else if(document.layers) nn4=true;\n"
      . "function autoResize() {\n"
      . " if(ie5) self.resizeTo(document.images[0].width+10,document.images[0].height+38);\n"
      . " else if(nn6) self.sizeToContent();\n"
      . " else top.window.resizeTo(document.images[0].width,document.images[0].height);\n"
      . " self.focus();\n"
      . "}\n"
    );
  $RESPONSE->set_onload("autoResize()");
}

$RESPONSE->plugin("MAIN_CONTENT", $catitem->Insitu(true, true));

// -----------------------------------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>