<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    usersetup.php                                           */
/* Author:      Paul Waite                                              */
/* Description: User setup page                                         */
/*                                                                      */
/* ******************************************************************** */
include_once("application.php");

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page("User Setup", "maint", $theme);

// -----------------------------------------------------------------------
// Site-specific content..
include_once("site-webpage.php");
include_once("maintainer-defs.php");

//debug_on(DBG_SQL|DBG_DUMP|DBG_DIAGNOSTIC);
//debug_on(DBG_ALL);

// -----------------------------------------------------------------------
// AUTHORISATION
// No guests allowed to see content..
if (!$RESPONSE->ismemberof_group_in("Admin,Editor")) {
  $RESPONSE->send();
  exit;
}

// User type form widget..
$utype = new form_combofield("user_type", "User type");
$utype->setclass("axcombo");
$utype->additem("user", "Standard user");
$utype->additem("sys", "System engineer");

$maint = new maintainer("Users", "ax_user");
$maint->setalign("center");
$maint->view_primary_keys();
$maint->set_formfieldwidget("user_type", $utype);
$maint->view_passwords();
$maint->set_viewonlyfields("auth_code,last_login,total_logins");
$maint->set_fieldtexttype("password", "password");
$maint->set_datetimeformat("last_login", SHORT_DATETIME);
$maint->set_fieldsize("limit_logins", 50);
$maint->set_nonblankfields("full_name,email");

if ($RESPONSE->user_type != "sys") {
  $maint->set_hiddenfields("user_type");
}

$maint->linked_table("Group Membership", "ax_group", "ax_user_group", "checkbox");

$ip_head = "User IPs"
. "<p><span class=axfg>"
. "Enter IP addresses for either single hosts or networks. "
. "with each address on a separate line. "
. "A host is a full address like this: 204.13.223.3. A Class C "
. "network of machines can be entered short-hand like this: 204.13.223 or like "
. "this: 204.13.223.0, or properly, like this: 204.13.223.0/24. When you save "
. "the list, the system will re-format your entries"
. "</span></p>";

$maint->set_encrypted_passwords($RESPONSE->encrypted_passwords);
$maint->detail_table($ip_head, "ax_user_ip", "", 300);
$maint->set_fieldpostproc("ip", "ip_format");
$maint->set_fieldpostproc("password", "set_password");
$maint->set_labelfields("ax_user_ip", "ip");

$RESPONSE->plugin("MAIN_CONTENT", $maint->render());

// -----------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>