<?php

/************

FileUserStore
A very simple user storage backend which stores users in a flat file.
Example entry in b.site:
   userbackend = file, /path/to/b.users

*************/

$base = dirname(dirname(__FILE__));
require_once("$base/UserStore.php");

class FileUserStore extends UserStore {

var $file;

function FileUserStore($args) {
	if (is_file($args)) {
		$this->file = $args;	
	}
	elseif (is_file($GLOBALS['docroot'] . "/" . $args)) {
		$this->file = $GLOBALS['docroot'] . "/" . $args;
	}
	else {
		$this->file = '';
	}
}

function authenticate($user,$pass,&$error) {
	if (!$this->file) {
		$error = "The user storage file is missing.";
		return;
	}
	elseif (!is_readable($this->file)) {
		$error = "The user storage file is unreadable";
		return;
	} 
	
	$data = file($this->file);
	$userlines = preg_grep("/$user:/",$data);
	if (count($userlines)) {
		$userline = current($userlines);
		list($storeduser,$storedpass) = explode(":",rtrim($userline));
		$seed = preg_replace('/^\$.\$(.*)\$.*$/','$1',$storedpass);
		$hash_pass = crypt($pass,'$1$'.$seed);
		if ($user == $storeduser && $pass == $storedpass) {
			return true;
		}
		elseif ($user == $storeduser && $hash_pass == $storedpass) {
			return true;
		}
		else {
			$error = _("User or password is incorrect");
			return false;
		}
	}
	else {
		$error = _("User or password is incorrect");
		return false;
	}
}

} // end class

return;
?>
