/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   sebastien.laout@tuxfamily.org                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef VARIOUSWIDGETS_H
#define VARIOUSWIDGETS_H

#include <qwidget.h>
#include <qcombobox.h>

class QString;
class QLineEdit;

/** A widget to select a command to run,
  * with a QLineEdit and a QPushButton.
  * @author Sbastien Laot
  */
class RunCommandRequester : public QWidget
{
  Q_OBJECT
  public:
	RunCommandRequester(const QString &runCommand, const QString &message, QWidget *parent = 0, const char *name = 0);
	~RunCommandRequester();
	QString runCommand();
	void setRunCommand(const QString &runCommand);
	QLineEdit *lineEdit() { return m_runCommand; }
  private slots:
	void slotSelCommand();
  private:
	QLineEdit *m_runCommand;
	QString    m_message;
};

/** QComboBox to ask icon size
  * @author Sbastien Laot
  */
class IconSizeCombo : public QComboBox
{
  Q_OBJECT
  public:
	IconSizeCombo(bool rw, QWidget *parent = 0, const char *name = 0);
	~IconSizeCombo();
	int iconSize();
	void setSize(int size);
};

#endif // VARIOUSWIDGETS_H
