/* unit-pfs.c
 *
 ****************************************************************
 * Copyright (C) 2004, Canonical Limited
 *               Author: Robert Collins, Rob Weir
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "hackerlab/bugs/panic.h"
#include "hackerlab/char/str.h"
#include "libarch/pfs.h"


/* typedefs */



/* local methods */



int
main (int argc, char * argv[])
{
  t_uchar * dir;

  /* FIXME: test abs_path */
  invariant (!str_cmp ("/foo/bar", dir = arch_pfs_abs_path ("/foo/bar/.")));
  lim_free (0, dir);
  invariant (!str_cmp ("/foo", dir = arch_pfs_abs_path ("/foo/bar/..")));
  lim_free (0, dir);
  invariant (!str_cmp ("/foo", dir = arch_pfs_abs_path ("/foo/bar/gam/../..")));
  lim_free (0, dir);
  invariant (!str_cmp ("http://localhost/", dir = arch_pfs_abs_path ("http://localhost/")));
  invariant (!str_cmp ("/foo/bar", dir = arch_abs_path ("/foo/bar/.")));
  lim_free (0, dir);
  invariant (!str_cmp ("/foo", dir = arch_abs_path ("/foo/bar/..")));
  lim_free (0, dir);
  invariant (!str_cmp ("/foo", dir = arch_abs_path ("/foo/bar/gam/../..")));
  lim_free (0, dir);
  invariant (str_cmp ("http://localhost/", dir = arch_abs_path ("http://localhost/")));
  lim_free (0, dir);

  return 0;
}
