// DCCConnection.C  -*- C++ -*-
// Copyright (c) 1998 Etienne BERNARD

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <time.h>

#include "Socket.H"
#include "DCCParser.H"
#include "DCCConnection.H"

DCCConnection::DCCConnection(Bot *b, String n, unsigned long address, int port)
 : Connection(address, port), bot(b), nuh(n),
   lastSpoken(time(0)), autoRemove(true)
{ }

bool
DCCConnection::connect()
{
  if (!socket.connect())
    return false;

  return true;
}

bool
DCCConnection::handleInput()
{
  String line = socket.readLine();

  lastSpoken = time(0);

  if (line.length() == 0)
    return true;

  if (bot->debug)
    cout << "DCC: <" << line << ">" << endl;

  DCCParser::parseLine(this, line);

  return false;
}

void
DCCConnection::sendNotice(String message)
{
  socket.write(message, true);
}
