/***************************************************************************
                          dlghelp.cpp  -  description
                             -------------------
    begin                : Mon Dec 30 2002
    copyright            : (C) 2002 by Ken Schenke
    email                : kenschenke at yahoo dot com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, as a special exception, Ken Schenke gives permission to  *
 *   link the code of this program with the Qt non-commercial edition (or  *
 *   with modified versions of the Qt non-commercial edition that use the  *
 *   same license as the Qt non-commercial edition, and distribute linked  *
 *   combinations including the two.  You must obey the GNU General Public *
 *   License in all respects for all of the code used other than the Qt    *
 *   Non-Commercial edition.  If you modify this file, you may extend this *
 *   exception to your version of the file, but you are not obligated to   *
 *   do so.  If you do not wish to do so, delete this exception statement  *
 *   from your version.                                                    *
 *                                                                         *
 ***************************************************************************/

#include "dlghelp.h"
#include "images.h"

#ifdef Q_WS_X11
#include "config.h"
#endif

#include <qtextbrowser.h>
#include <qpushbutton.h>
#include <qpixmap.h>

/***************************************************************************
 *                                                                         *
 *   DlgHelp::DlgHelp()                                                    *
 *                                                                         *
 *   Parameters:                                                           *
 *      QWidget *parent                                                    *
 *      const char *name                                                   *
 *      bool modal                                                         *
 *      WFlags f                                                           *
 *   Return:                                                               *
 *      None                                                               *
 *   Description:                                                          *
 *      Class constructor                                                  *
 *                                                                         *
 ***************************************************************************/

DlgHelp::DlgHelp(
	const BridgeCfg &cfg,
	QWidget *parent,
	const char *name,
	bool modal,
	WFlags f)
	: DlgHelpBase(parent, name, modal, f), m_cfg(cfg)
{
	QPixmap backImg, forwardImg, homeImg;

	backImg.convertFromImage(qembed_findImage("backbutton"));
	forwardImg.convertFromImage(qembed_findImage("forwardbutton"));
	homeImg.convertFromImage(qembed_findImage("homebutton"));

	buttonBack->setPixmap(backImg);
	buttonForward->setPixmap(forwardImg);
	buttonHome->setPixmap(homeImg);
}

void DlgHelp::setSource(const char *source)
{
	QString html_file;

#if defined(Q_WS_X11)
	html_file.sprintf("file://%s/bookmarkbridge/%s", DATADIR, source);
#elif defined(Q_WS_WIN)
	html_file.sprintf("%s/%s", m_cfg.datadir.c_str(), source);
#else
#error "Must define location of about.html"
#endif
	browserHelp->setSource(html_file);
}
