#ifndef _DEBUG_CPP_
#define _DEBUG_CPP_

#include <iostream.h>

#include <reference.h>
#include <table.h>
#include <event.h>
#include <part.h>
#include <track.h>
#include <song.h>
#include <str.h>
#include <prMainEditor.h>
#include <position.h>

#include "debug.h"

extern Table * selectioN;
extern Table * selectionMemory;
extern Song * sonG;
extern PrMainEditor * mainEditor;

#define DEBUG_CONTEXT Addon::TREAT_ALL

extern "C" {
  Addon * debug(Element * target) { return new Debug(target); }
  const char  * debug_name() { return "debug"; }
  const char  * debug_category() { return "testing"; }
  int     debug_context() { return DEBUG_CONTEXT; }
}


Debug::Debug(Element * target) : Addon("debug info", target, !TO_BE_UNDONE, DEBUG_CONTEXT) { run(); }

Debug::~Debug() {

}

void Debug::selection(Table * selection) {
  global();
}

void Debug::part(Part * part) {
  global();
}

void Debug::track(Track * track) {
  global();
  cout << "\n -- parts:\n" << endl;
  for (Part * part = (Part*) track->first(); part!=0; part = (Part*) track->next(part)) {
    Position p = part->start();
    cout << " Part ord: " << part->ord(track) << ", at: " << p << ", size: " << part->size() << endl;
  }
}

void Debug::song(Song * song) {
  global();
}

void Debug::global() {
  cout << "\nDebug info:\n" << endl;
#ifdef DEBUGIT
  cout << "total elements: " << sonG->total() << endl;
#endif
  cout << endl;
#ifdef DEBUGIT
  sonG->dump();
#endif
  mainEditor->dumpEditors();
  cout << "\nselection: " << selectioN->size() << endl;
  cout << "memory: " << selectionMemory->size() << endl;
  cout << endl;
}

void Debug::undo() {
}

void Debug::redo() {
}






#endif
