#ifndef _QTEAR_CPP_
#define _QTEAR_CPP_

#include <iostream.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include "qtEar.h"

#include <song.h>
#include <player.h>

#include <qstrlist.h>

extern Song * sonG;


const char * intnames[] = {"Prime", "kleine Sekunde", "grosse Sekunde", "kleine Terz", "grosse Terz", "Quarte", "uebermaessige Quarte", "Quinte",
			   "kleine Sexte", "grosse Sexte", "kleine Septime", "grosse Septime", "Oktave", "kleine None", "grosse None"};
const char * c3names[] = {"Grundstellg. Dur", "1. Umkehrung Dur", "2. Umkehrung Dur", "Grundstellg.Moll", "1. Umkehrung Moll", "2. Umkehrung Moll"};


QtEar::QtEar() : player(0), speed(6), output(0) {
  QStrList * devList = new QStrList();
  for (int i=0;i<sonG->player()->devicenum();i++) devList->append(sonG->player()->device(i));

  // init GUI
  inttxt = new char[40];
  inttxt1 = new char[40];
  c3txt = new char[40];
  setFixedSize(300,220);

  QLabel * outLab = new QLabel("output: ", this);
  outLab->setGeometry(2,2,96,24);
  outLab->show();
  outputbox = new QComboBox(FALSE,this,"output");
  outputbox->insertStrList( devList );
  outputbox->setCurrentItem(output);
  outputbox->setGeometry(100,2,96,24);
  connect(outputbox,SIGNAL(highlighted(int)),SLOT(updateOut(int)));

  QLabel * speedLab  = new QLabel("tempo: ",this);
  speedLab->setGeometry(200,2,48,24);
  speedLab->show();
  speedBox  = new QSpinBox(1,20,1,this); speedBox->setValue(speed);
  speedBox->setGeometry(250,2,48,24);
  connect(speedBox,SIGNAL(valueChanged(int)),SLOT(updateSpeed(int)));

  intervals = new QPushButton("Hear Intervals", this);
  intervals->setGeometry(2,36,96,24);
  intervals->show();
  connect(intervals,SIGNAL(released()),SLOT(startIntervals()));
  intlab = new QLabel(this);
  intlab->setText(" - ");
  intlab->setGeometry(100,36,width()-102,24);

  intervals1 = new QPushButton("Build Interval", this);
  intervals1->setGeometry(2,62,96,24);
  intervals1->show();
  connect(intervals1,SIGNAL(released()),SLOT(startIntervals1()));
  intlab1 = new QLabel(this);
  intlab1->setText(" - ");
  intlab1->setGeometry(100,62,width()-102,24);

  chord3 = new QPushButton("Hear Chord (3)", this);
  chord3->setGeometry(2,100,96,24);
  chord3->show();
  connect(chord3,SIGNAL(released()),SLOT(startChord3()));
  c3lab = new QLabel(this);
  c3lab->setText(" - ");
  c3lab->setGeometry(100,100,width()-102,24);



  QPushButton * quit = new QPushButton(this);
  quit->setText("close");
  quit->setGeometry(2,height()-26,width()-4,24);
  quit->show();
  connect( quit, SIGNAL(released()), SLOT(quit()) );
  show();

  // init timer

  timer = new QTimer(this);
  connect( timer, SIGNAL(timeout()), SLOT(done()) );
  timer1 = new QTimer(this);
  connect( timer1, SIGNAL(timeout()), SLOT(done1()) );
  timer2 = new QTimer(this);
  connect( timer2, SIGNAL(timeout()), SLOT(done2()) );
  myTime = new timeb;
}

void QtEar::startIntervals() {
  // tlab->setText(" - ");
  int qq = ftime(myTime);
  unsigned int tt = (unsigned int) myTime->millitm;
  srand(tt);
  long int rnd = ::rand();
  int fst = rnd%14;
  rnd = ::rand();
  int snd = rnd%14;
  
  int interval = abs(snd-fst);
  sprintf(inttxt," %s ", intnames[interval]);
  
  sonG->player()->hit(output,0,44+fst,120);
  sonG->player()->hit(output,0,44+snd,120);
  //main->closeDev();
  timer->start(speed * 1000,true);
}

void QtEar::done() {
  intlab->setText(inttxt);
}

void QtEar::startIntervals1() {
  int qq = ftime(myTime);
  unsigned int tt = (unsigned int) myTime->millitm;
  srand(tt);
  long int rnd = ::rand();
  int fst = rnd%14;
  rnd = ::rand();
  buildInt = rnd%14;
  
  int interval = abs(buildInt-fst);
  if (buildInt>fst) sprintf(inttxt1," %s aufwaerts", intnames[interval]);
  else sprintf(inttxt1," %s abwaerts", intnames[interval]);
  intlab1->setText(inttxt1);
  
  sonG->player()->hit(output,0,44+fst,120);
  timer1->start(speed * 1000,true);
}

void QtEar::done1() {
  sonG->player()->hit(output,0,44+buildInt,120);
  //main->closeDev();
  intlab1->setText(" - ");
}

void QtEar::startChord3() {
  c3lab->setText(" - ");
  int qq = ftime(myTime);
  unsigned int tt = (unsigned int) myTime->millitm;
  srand(tt);
  long int rnd = ::rand();
  int fst = rnd%14;
  rnd = ::rand();
  int type = rnd%6; // 0,3: Grundstellung, 1,4: 1.Umkehrung, 2,5: 2.Umkehrung, 0-2: Dur, 3-5: Moll
  int snd = fst;
  int thd = fst;
  switch (type) {
  case 0: snd += 4; thd += 7; break;
  case 1: snd += 3; thd += 8; break;
  case 2: snd += 5; thd += 8; break;
  case 3: snd += 3; thd += 7; break;
  case 4: snd += 4; thd += 9; break;
  case 5: snd += 5; thd += 8; break;
  }

  sprintf(c3txt," %s ", c3names[type]);
  
  sonG->player()->quad(output,0,44+fst,44+snd,44+thd,0,120);
  //main->closeDev();
  timer2->start(speed * 1000,true);
}

void QtEar::done2() {
  c3lab->setText(c3txt);
}


void QtEar::updateSpeed(int i) {
  speed = i;
}

void QtEar::updateOut(int n) {
  output = n;
}

void QtEar::quit() {
  delete this;
}



#endif
