#ifndef _QUANTIZEALL_H_
#define _QUANTIZEALL_H_

#include <element.h>

#include <addon.h>
#include <table.h>
#include <part.h>
#include <track.h>
#include <vector.h>

class QuantizeAll : public Addon
{
 private:
  long * pos;
  long * len;
  int context;
  int count;

 public:
  /** The constructor is given a parameter specifying the target of the operation
   * implement this typically for a Song, Track, Part and NULL, where NULL indicates that
   * the globally defined table * selectioN is used as a target
   */
  QuantizeAll(Element*);
  ~QuantizeAll();

  virtual void selection(Table*);
  virtual void part(Part*);
  virtual void track(Track*);
  virtual void song(Song*);
  
  void undo();
  void redo();



};

#endif
