#ifndef _RIEMANN_H_
#define _RIEMANN_H_

#include <element.h>

#include <addon.h>
#include <table.h>
#include <part.h>
#include <track.h>

#include "chord.h"
#include "harmony.h"




#define MAXINTERVALS 20


class Riemann : public Addon
{

  friend class Track;

 private:
  int _pit[MAXINTERVALS+1]; // pitch z.B.     55 58 62 67 (%12 = 7 10 2 7) (g-moll)
  int _stf[MAXINTERVALS+1]; // stufe z.B.      2 7 10                      (d, g, b)
  int _enh[MAXINTERVALS+1]; // enharmonic sft: 0 0 -1                      (-1: b und nicht ais!)
  int _mul[MAXINTERVALS+1]; // multiplizitt:  1 2  1
  Harmony current;
  Harmony recent;
  void sortPitches(int * pi, int * en, int & dim, int * mul, bool remove_doubles);
  char * help;
  
 public:
  /** The constructor is given a parameter specifying the target of the operation
   * implement this typically for a Song, Track, Part and NULL, where NULL indicates that
   * the globally defined table * selectioN is used as a target
   */
  Riemann(Element*);
  ~Riemann();

  virtual void song(Song*);
  
  void undo();
  void redo();
  
};


#endif
