#ifndef _AUDIOEVENT_H_
#define _AUDIOEVENT_H_

#include "event.h"
#include "position.h"

/**
 * Objects of this class are audio events. They do not need a (graphical) presentation of their own. They can be displayed
 * graphically within the presentation of the parts they belong to, which is done in editors.
 *
 * Aside from the event's position AudioEvents contain a filename to a wav file, which is used to play the audio information.
 *
 **/
class AudioEvent : public Event
{
 private:
  const char *   _filename;

 public:
  /**
   * Default constructor
   **/
  AudioEvent( );

  /**
   * Constructor with the start position, the length and the filename as parameters
   **/
  AudioEvent(Position start, long len, const char* name);

  /**
   * Returns the filename including the full path
   **/
  const char * fileName();

  /**
   * Returns the filename without the path
   **/
  const char * name();

  /**
   * Sets the filename
   **/
  void setFileName(const char*);

  /**
   * Implementation of the print method
   **/
  virtual ostream & print(int,ostream&) const;

  /**
   * Implementation of the flush method
   **/
  virtual void flush(const char*) const;

  /**
   * Implementation of the copy method
   **/
  virtual Element * copy() const;

  /**
   * Implementation of the load method
   **/
  static Element * load(char*,ifstream*&,Element*);
};


#endif
