#ifndef _COPYGHOSTPART_CPP_
#define _COPYGHOSTPART_CPP_

#include <iostream.h>

#include "copyGhostPart.h"
#include "element.h"
#include "compound.h"

#include "part.h"
#include "track.h"
#include "song.h"
extern Song * sonG;

CopyGhostPart::CopyGhostPart(Position p, Part * pt, Track * src, Track * tgt)
  : _part(0), _src(src), _tgt(tgt), _old(pt->start()), _new(p) {
  _type = COPYGHOSTPART;
  _description = "copy ghost part";
  _to_be_undone = true;
  if (pt) _part = (Part*) pt->ghostcopy();
  if (_part) {
    _tgt->add(_part);
    _part->setTrack(_tgt);
    _part->setStart(_new);
  }
}

CopyGhostPart::CopyGhostPart(const CopyGhostPart& el) : Operation(el) {
  _type = COPYGHOSTPART;
  _part = el._part;
  _old = el._old;
  _new = el._new;
}

CopyGhostPart::~CopyGhostPart() {
}

void CopyGhostPart::undo() {
  if (_part) {
    _tgt->remove(_part);
    _part->hide();
  }
}

void CopyGhostPart::redo() {
  if (_part) {
    _tgt->add(_part);
    _part->show();
  }
  _part->reorder();
}



// ---------------
// virtuals:
//

ostream & CopyGhostPart::print(int dep, ostream & s) const {
  s << spc(dep) << "<COPYGHOSTPART part=\"" << _part << "\" old=\"" << _old << "\" new=\"" << _new << "\" />" << endl;
  return s;
}

void CopyGhostPart::flush(const char * c) const {
  cout << c << "COPYGHOSTPART" << endl;
}

Element * CopyGhostPart::copy() const {
  return new CopyGhostPart(*this);
}




#endif
