#ifndef _EXPRESSION_CPP_
#define _EXPRESSION_CPP_

#include <string.h>
#include <iostream.h>
#include <stdlib.h>
#include <fstream.h>
#include "expression.h"
#include "part.h"
#include "loader.h"
#include "table.h"
#include "str.h"

Expression::Expression() : _exp(0), _displacement(0) { _type = EXPRESSION; }

Expression::Expression(int ex) : _exp(ex), _displacement(0) { _type = EXPRESSION; }

Expression::Expression(const Expression& o) : Ornament(o) {
  _type = EXPRESSION;
  _exp = o._exp;
  _displacement = o._displacement;
}

int Expression::expression() { return _exp; }

int Expression::displacement() { return _displacement; }

void Expression::setExpression(int e) { _exp = e; }

void Expression::setDisplacement(int d) { _displacement = d; }


// virtuals:


ostream & Expression::print(int dep, ostream & s) const {
  s << spc(dep) << "<EXP expression=\"" << _exp << "\" offset=\"" << _displacement << "\" />" << endl;
  return s;
}

void Expression::flush(const char * c) const {
  cout << c << "EXP " << _exp << ", " << _displacement << endl;

}

Element * Expression::copy() const {
  return new Expression(*this);
}


Element * Expression::load(char * aline, ifstream *& , Element * ) { // inPtr, parent
  Expression * expr = new Expression();

  Table * attr = Loader::getAttributes("EXP",aline);
  if (attr!=0) {
    int ex = 0;
    int dis = 0;

    if (attr->getEntry("expression")) ex = atoi(((String*) attr->getEntry("expression"))->getValue());
    if (attr->getEntry("offset")) dis = atoi(((String*) attr->getEntry("offset"))->getValue());

    expr->setExpression(ex);
    expr->setDisplacement(dis);

    attr->scratch();
    delete attr;
  }
  return expr;
}

#endif
