#ifndef _PRSCOREEDITOR_CPP_
#define _PRSCOREEDITOR_CPP_

#include "prScoreEditor.h"
#include "table.h"
#include "part.h"
#include "track.h"
#include "reference.h"
#include "str.h"
#include "song.h"
#include "prFactory.h"

extern Song * sonG;

enum { ID_TOOL_IN, ID_TOOL_ANS, ID_TOOL_AOS };

// int sharpTab[] = { 0, 9, -3, 6, 15, 3, 12 };
// int flatTab[] = { 12, 3, 15, 6, 18, 9, 0 };
// int signShift[] = { 0, 6, 0, 0, 0, 6, 6, 12, 0, -6, 9, 3, -3, 0 };

int sharpTab[] = { 0, 3, -1, 2, 5, 1, 4 };
int flatTab[] = { 4, 1, 5, 2, 6, 3, 0 };
int signShift[] = { 0, 2, 0, 0, 0, 2, 2, 4, 0, -2, 3, 1, -1, 0 };

// int invFreq[] = { 58, 58, 57, 57, 56, 55, 55, 54, 54, 53, 53, 52, 51, 51, 50, 50, 49, 48, 48, 47, 47, 46, 46, 45, 44, 44, 43, 43, 42, 41, 41, 40, 40, 39, 39, 38, 37, 37, 36, 36, 35, 34, 34, 33, 33, 32, 32, 31, 30, 30, 29, 29, 28, 27, 27, 26, 26, 25, 25, 24, 23, 23, 22, 22, 21, 20, 20, 19, 19, 18, 18, 17, 16, 16, 15, 15, 14, 13, 13, 12, 12, 11, 11, 10, 9, 9, 8, 8, 7, 6, 6, 5, 5, 4, 4, 3, 2, 2, 1 ,1, 0 };

int invPitch[] = { 58, 58, 57, 57, 56, 55, 55, 54, 54, 53, 53, 52, 51, 51, 50, 50, 49, 48, 48, 47, 47, 46, 46, 45, 44, 44, 43, 43, 42, 41, 41, 40, 40, 39, 39, 38, 37, 37, 36, 36, 35, 34, 34, 33, 33, 32, 32, 31, 30, 30, 29, 29, 28, 27, 27, 26, 26, 25, 25, 24, 23, 23, 22, 22, 21, 20, 20, 19, 19, 18, 18, 17, 16, 16, 15, 15, 14, 13, 13, 12, 12, 11, 11, 10, 9, 9, 8, 8, 7, 6, 6, 5, 5, 4, 4, 3, 2, 2, 1 ,1, 0 };

int sign[] = {  0,  1,  0,  1,  0,  0,  1,  0,  1,  0,  1,  0,  0,  1,  0,  1,  0,  0,  1,  0 , 1,  0,  1,  0,  0,  1,  0,  1,  0,  0,  1 , 0,  1,  0,  1,  0,  0,  1,  0,  1,  0,  0,  1,  0 , 1,  0,  1,  0,  0,  1,  0,  1,  0,  0,  1,  0 , 1,  0,  1,  0,  0,  1,  0,  1,  0,  0,  1,  0,  1,  0,  1,  0, 0, 1, 0 ,1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1 ,0, 1, 0, 0, 1, 0, 1, 0, 1, 0};

int enhF[5][12] = {
  { -1, -1, -1, -2, -1, -1, -1, -1, -1, -1, -2, -1 },
  {  0, -1,  0, -1, -1,  0, -1,  0, -1,  0, -1, -1 },
  {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  {  1,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0 },
  {  1,  1,  1,  0,  1,  1,  1,  1,  0,  1,  0,  1 }
};

int enhS[5][12] = {
  { -2, -1, -2, -2, -1, -2, -1, -2, -1, -2, -2, -1 },
  {  0, -1,  0, -1, -1,  0, -1,  0, -1,  0, -1, -1 },
  {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
  {  1,  1,  0,  1,  0,  1,  1,  0,  1,  0,  1,  0 },
  {  1,  2,  2,  1,  2,  1,  2,  2,  1,  2,  1,  2 }
};

int yClef[] = { 0,-12,7,14,-7,-19,-26,-10,-14,-2,-4,-6,-8 };


int noteTab[] = { 'e', 'd', 'c', 'h', 'a', 'g', 'f' };
int freqTab[] = {100, 98, 96, 95, 93, 91, 89, 88, 86, 84, 83, 81, 79, 77, 76, 74, 72, 71, 69, 67, 65, 64, 62, 60, 59, 57, 55, 53, 52, 50, 48, 47, 45, 43, 41, 40, 38, 36, 35, 33, 31, 29, 28, 26, 24};

int scrSigns[8] = { 0, 0, 0, 0, 0, 0, 0, 0 };

int allSigns[15][7] = {
 {-1, -1, -1, -1, -1, -1, -1 },
 {-1, -1, -1, -1, -1, -1,  0 },
 {-1, -1,  0, -1, -1, -1,  0 },
 {-1, -1,  0, -1, -1,  0,  0 },
 {-1,  0,  0, -1, -1,  0,  0 },
 {-1,  0,  0, -1,  0,  0,  0 },
 {0,   0,  0, -1,  0,  0,  0 },
 {0, 0, 0, 0, 0, 0, 0 },
 {0, 0, 0, 0, 0, 0, 1 },
 {0, 0, 1, 0, 0, 0, 1 },
 {0, 0, 1, 0, 0, 1, 1 },
 {0, 1, 1, 0, 0, 1, 1 },
 {0, 1, 1, 0, 1, 1, 1 },
 {1, 1, 1, 0, 1, 1, 1 },
 {1, 1, 1, 1, 1, 1, 1 }
};

const char * bClef2mClef[] = {"treble", "bass", "treble", "treble", "treble8", "bass", "bass", "bass", "bass", "soprano", "mezzosoprano", "alto", "tenor", "bass"};

const char * extNoteNames[] = {
  "nsStaccato", "nsLegato", "nsAccDown", "nsAccUp", "nsAccent1", "nsAccent2", "nsAccent3", "nsAccent4",
  "nsAccent5", "nsAccent6", "nsAccent7", "nsAccent8", "nsAccent9", "nsAccent10", "nsAccent11", "nsTriller",
  "nsTrill1", "nsTrill2", "nsInf", "nsBowUp", "nsBowDown" };

const char * auxScoreNames[] = {
  "asLabel1", "asLabel2", "asLabel3", "asCase1", "asCase2", "asPedal1", "asPedal2", "asNotedot",
  "asNote3", "asNote6", "asNotexx", "as8va", "as15va", "asTrillX", "asTrillX2", "asDecrescendo",
  "asCrescendo", "asBracketUp", "asBracketDown", "asArpeggio", "asText",
  "dynPPP", "dynPP", "dynP", "dynMP", "dynMF", "dynF",
  "dynFF", "dynFFF", "dynSFZ", "dynSF", "dynSFF", "dynFP" };





PrScoreEditor::PrScoreEditor()
  : PrPartEditor(SCOREEDITOR), _score_iterator(0), _horizontal_beams(false), _beams_exceed_breaks(false)
{

}

PrScoreEditor::PrScoreEditor(Part * p)
  : PrPartEditor(p), _score_iterator(0), _horizontal_beams(false), _beams_exceed_breaks(false)
{

}

PrScoreEditor::PrScoreEditor(Track * t)
  : PrPartEditor(t), _score_iterator(0), _horizontal_beams(false), _beams_exceed_breaks(false)
{

}

PrScoreEditor::~PrScoreEditor() {
  if (_score_iterator != 0) delete _score_iterator;
}

void PrScoreEditor::update() {

}

void PrScoreEditor::setHorizontalBeams(bool b) { _horizontal_beams = b; }

void PrScoreEditor::setBeamsExceedBreaks(bool b) { _beams_exceed_breaks = b; }

void PrScoreEditor::setIterator(ScoreIterator * it) { _score_iterator = it; }

bool PrScoreEditor::isScoreEditor() const { return true; }

long PrScoreEditor::ticks(int xpos, ScoreArea & area) const {
  if (_score_iterator != 0) return _score_iterator->ticks(xpos, area);
  else return 0;
}

int PrScoreEditor::xposition(long ticks) {
  if (_score_iterator != 0) return _score_iterator->xposition(ticks);
  else return 0;
}

int PrScoreEditor::xposition(Position pos) {
  if (_score_iterator != 0) return _score_iterator->xposition(pos.ticks());
  else return 0;
}


/*
void PrScoreEditor::drawChord() {
  Position pos = Pos()+relPos-off;
  xx = int ((Pos()+relPos-off)*pixPerTick + xoffset + 5);
  xxShift = 0;
  yy = 0;
  Note * note;
  int middleStem = 0;
  int yAverage = 0;
  int count = 0;
  _yBottom = 0;
  _yTop = 99;


  // Loop through this chord
  for (NotePtr * np = top; np!=0; np = np->Next()) {
    yyOld = yy;
    note = np->gNote();
    int freq = note->pitch();
    int len = note->length();
    int enh = note->enh();
    int chan = note->chan();
    QPixmap img;

    int step = freq%12;
    yy  = invFreq[freq];
    int sg  = sign[freq];
    if (enh!=0) { yy += enhF[enh+2][step]; sg = enhS[enh+2][step]; }

    int sgMem = scrSigns[yy%7]; // Sign
    scrSigns[yy%7] = sg;
    if (sgMem == sg) { sg = 0; } else { if (sg==0) { sg = 3; } }
    // change yy when different clef
    if (scrClef!=0) yy += yClef[scrClef];
    if (yy<1) { yy = 1; }

    // if notes are only one line apart, move:
    if (abs(yyOld-yy)<2) {
      xxShift += 8;
      if (xxShift == 16) xxShift = 0;
      middleStem = 1;
    } else {
      xxShift = 0;
    }
    // draw helplines, above and below the score:
    for (int i=yy/2; i<6; i++) { score->drawLine(QPoint(xx-3,i*6+yoffset+5),QPoint(xx+9,i*6+yoffset+5)); }
    for (int i=(yy-1)/2; i>10; i--) { score->drawLine(QPoint(xx-3,i*6+yoffset+5),QPoint(xx+9,i*6+yoffset+5)); }
    // draw sign DOIT, position right ?!
    if (sg!=0) { score->drawPixmap(xx-11,yy*3+yoffset-10-2*(sg<0),imgSignPtr[sg+2]); }
    // chose and draw notebody (empty or filled):
    if (len>767) { img = imgNotePtr[0]; } else { img = imgNotePtr[1]; }
    // if ((selNote==note) || (selX1!=-1 && selX1 <= Pos() && Pos() <= selX2)) {
    if (selectioN->hasEntry(note)) {
      // score->setPen(Qt::red); // COLOR
      score->fillRect(xx+xxShift-2,yy*3+yoffset-2,11,7,Qt::darkGray);
    } else {
      if (colorchan && (chan>-1)) {
	score->setPen(QColor((chan*33)%360,120,240,QColor::Hsv));
      } else {
	score->setPen(Qt::black);
      }
    }
    score->drawPixmap(xx+xxShift,yy*3+yoffset-1,img);

    if (colorchan && (chan>-1)) { // TODO: only provisorical solution: I rather want to color the pixmap !!!
      score->drawEllipse(xx+xxShift+1,yy*3+yoffset+1,5,3);
      score->drawLine(xx+xxShift+1,yy*3+yoffset+2,xx+xxShift+5,yy*3+yoffset+2);
      score->drawLine(xx+xxShift+1,yy*3+yoffset+3,xx+xxShift+5,yy*3+yoffset+1);
    }

    score->setPen(Qt::black);
    // dotted?
    int dot = DOT(len);
    for (int i=0;i<dot;i++) {
      score->drawText(xx+10+5*i,yy*3+yoffset,".");
    }

    // build the y-average, set bottom/top:
    if (_yTop>yy) _yTop = yy;
    if (_yBottom<yy) _yBottom = yy;
    yAverage += yy;
    count++;

    //
    // ORNAMENTS
    //
    Vector * vec = note->ornament();
    for (Ornament * orn = (Ornament*) vec->first(); orn != 0; orn = (Ornament*) vec->next(orn)) {
      if (orn->isA()==EXPRESSION) {
	Expression * exp = (Expression*) orn;
	score->drawPixmap(xx+xxShift-7,yoffset+3*yy+exp->displacement()-8,imgNoteAccentPtr[exp->expression()]);
      } else if (orn->isA()==BOW) {
	// bow ?
	Bow * bow = (Bow*) orn;
	int bowlen = bow->length();
	int drc = bow->direction();
	if (drc==0) drc = -1;
	int x1 = xx+xxShift*8;
	int y1 = yoffset+3*yy + drc*8;
	int dx = int(bowlen*pixPerTick/3);
	int dy = int(bowlen*pixPerTick/12 * drc);
	int ddy = bow->delta()/3;

	QPointArray aa( 4 );
	aa.setPoint( 0, x1+4, y1 );
	aa.setPoint( 1, x1+dx, y1+dy + ddy );
	aa.setPoint( 2, x1+2*dx, y1+dy + 2*ddy );
	aa.setPoint( 3, x1+3*dx, y1 + 3*ddy );
	score->drawQuadBezier(aa);
	aa.setPoint( 1, x1+dx, y1+dy+1 + ddy );
	aa.setPoint( 2,x1+2*dx, y1+dy+1 + 2*ddy );
	score->drawQuadBezier(aa);
      } else if (orn->isA()==LYRICS) {
	const char * txt = note->lyrics()->get();
	score->drawText(xx+xxShift-7,yoffset+92,txt);
      } else if (orn->isA()==STEM) {
	// TODO!!!
      }
    }


  }

  // and now: set x-position of note and of stem
  _xPos = xx;
  if (middleStem==1) {
    _stemPos = xx + 8;
    _middle = true;
  } else {
    yAverage /= count;
    if (yAverage > 16) _stemPos = xx + 8;
    else _stemPos = xx;
    _middle = false;
  }
  if (yAverage > 16) _stemDir = 1; else _stemDir = -1;
  }*/


#endif
