#ifndef _SCOREBAR_CPP_
#define _SCOREBAR_CPP_

#include <iostream.h>
#include <stdio.h>

#include "scoreBar.h"
#include "scoreGroup.h"
#include "note.h"
#include "event.h"
#include "symbol.h"
#include "reference.h"
#include "part.h"
#include "track.h"
#include "prScorePainter.h"
#include "prScoreEditor.h"
#include "scoreTrack.h"
#include "prFactory.h"
#include "scorePrinter.h"

extern PrFactory * factory;


struct BarInitState {
  Position cur_pos;
  Position free_pos;
  Position next_group;
  ScoreGroup * group;
};


ScoreBar::ScoreBar(ScoreType scoretype, Part * part, bool isfirst, bool isactive) : _score_type(scoretype), _is_first(isfirst), _key(0), _clef(0), _meter0(0), _meter1(0), _program(0), _shortest(384), _scale(1), _common_indent(0), _common_raw_width(0), _active(isactive) {
  state = new BarInitState;
  state->cur_pos  = 0;
  state->free_pos = 0;
  state->next_group = 0;
  state->next_group.nextBeat();
  state->group = 0;
  if (part) {
    _key  = part->key();
    _clef = part->clef();
    _meter0 = part->meter0();
    _meter1 = part->meter1();
    _program = part->program();
    if (_program==128) _program = ((ScoreTrack*)part->track())->program();
  }
}

ScoreBar::~ScoreBar() {
  delete state;
}


void ScoreBar::add(Event * event, Position newpos, long dur, int dis, bool _no_overlap, bool _no_newgroup) {
  //
  // event=0 means: break!
  //
  if ( event==0 || event->isA() == NOTE ) {
    //
    // NOTE
    //
    if (int(dur) < _shortest && int(dur)>=32) _shortest = int(dur);
    if (!state->group) {
      state->group = new ScoreGroup();
      _groups.add(state->group);
      state->group->add((Note*)event, newpos, dur, dis, _no_overlap);
      state->cur_pos = newpos;
      if (newpos+dur > state->free_pos) {
	state->free_pos = newpos+dur;
	state->next_group = state->free_pos-1; // -1, in case the free pos starts at the next beat
	state->next_group.nextBeat();
      }
    } else {
      if (newpos < state->next_group) state->group->add((Note*)event, newpos, dur, dis, _no_overlap);
      else {
	if (!_no_newgroup) {
	  state->group = 0;
	  add((Note*)event,newpos,dur,dis,_no_overlap,false);
	} else {
	  state->group->add((Note*)event, newpos, dur, dis, _no_overlap);
	}
      }
    }
  } else if ( event->isA() == SYMBOL ) {
    //
    // SYMBOL
    //
    _symbols.add(new Reference(event));
  }
}

int ScoreBar::systemIndent() {
  return factory->getScorePainter()->indentSystem(this);
}

void ScoreBar::setIndent(int ind) { _common_indent = ind; }

void ScoreBar::setRawWidth(int i) { _common_raw_width = i; }

//

int ScoreBar::xindent() {
  if (multiple()) return _common_indent;
  else return systemIndent();
}

int ScoreBar::width() {
  int wd;
  if (multiple()) wd = int(_common_raw_width * _scale) + _common_indent;
  else wd = int(rawWidth() * _scale) + systemIndent();
  return wd;
}

double ScoreBar::unitsPerTick() {
  if (multiple()) return _common_raw_width * _scale * 1.0/duration();
  else return rawWidth() * _scale * 1.0/duration();
}

void ScoreBar::setMeter(int a, int b) { _meter0 = a; _meter1 = b; }

void ScoreBar::setScale(double d) { _scale = d; }

const char * ScoreBar::position() {
  char * txt = new char(5);
  sprintf(txt, "%d", start().bar());
  return txt;
}

ostream & ScoreBar::print(int dep, ostream & s) const {
  s << spc(dep) << "<SCOREBAR start=\"" << start() << "\" duration=\"" << duration() << "\" >" << endl;
  for (int i=0; i<_groups.size(); i++)
    _groups.get(i)->print(dep+1,s);
  for (int i=0; i<_symbols.size(); i++)
    ((Reference*)_symbols.get(i))->getValue()->print(dep+1,s);
  s << spc(dep) << "</SCOREBAR>" << endl;
  return s;
}

void ScoreBar::flush(const char * c) const {
  cout << c << "SCOREBAR" << endl;
}

Element * ScoreBar::copy() const {
  return new ScoreBar(_score_type, 0);
}




const Position & ScoreBar::start() const {
  if (_groups.first() != 0) return ((ScoreGroup*) _groups.first())->start();
  else return *(new Position(0)); // ### does that make sense?
}

long ScoreBar::end() const {
  long x = start().ticks();
  x += duration();
  return x;
}

long ScoreBar::duration() const {
  if (_groups.first() != 0)
    return ( ((ScoreGroup*) _groups.last())->end() - ((ScoreGroup*) _groups.first())->start().ticks() );
  else
    return 0;
}

int ScoreBar::display() const {
  if (_groups.first() != 0)
    return ( ((ScoreGroup*) _groups.last())->end() - ((ScoreGroup*) _groups.first())->start().ticks() );
  else
    return 0;
}

Reference * ScoreBar::symbols() { return (Reference*) _symbols.first(); }

void ScoreBar::paint(PrScoreEditor * ed, int x, int y, int style) {
  factory->getScorePainter()->paintBar(this, ed, &_groups, x, y, style);
}

void ScoreBar::print(PrScoreEditor * ed, int x, int y) {
  factory->getScorePrinter()->paintBar(this, ed, &_groups, x, y);
}

#endif
