#ifndef _SCORECHORD_CPP_
#define _SCORECHORD_CPP_

#include <iostream.h>

#include "scoreChord.h"

#include "note.h"
#include "reference.h"
#include "prScorePainter.h"
#include "prScoreEditor.h"
#include "prFactory.h"
#include "scorePrinter.h"

extern PrFactory * factory;


extern int invFreq[];
extern int sign[];
extern int enhF[5][12];
extern int enhS[5][12];
extern int yClef[];


ScoreChord::ScoreChord() {
}

ScoreChord::~ScoreChord() {
}

void ScoreChord::add(Note * note, Position pos, long dur, int dis, bool _no_overlap) {
  setStart(pos);
  _tuplet = note==0 ? 0 : note->tuplet();

  if (!_no_overlap) {
    dur = note->duration();
  }
  setDuration(dur);
  setDisplay(dis);
  Reference * ref = new Reference(note);
  _notes.add(ref); // TODO: assure low notes first!
}



bool ScoreChord::isBreak() const { return false; }

bool ScoreChord::isChord() const { return true; }

bool ScoreChord::hasNoFlags() const {
  return (display() >= 384);
}



ostream & ScoreChord::print(int dep, ostream & s) const {
  s << spc(dep) << "<SCORECHORD start=\"" << start() << "\" duration=\"" << duration() << "\" display=\"" << display() << "\" tuplet=\"" << _tuplet << "\" >" << endl;
  for (int i=0; i<_notes.size(); i++)
    ((Note*)((Reference*)_notes.get(i))->getValue())->print(dep+1,s);
  s << spc(dep) << "</SCORECHORD>" << endl;
  return s;
}

void ScoreChord::flush(const char * c) const {
  cout << c << "SCORECHORD" << endl;
}

Element * ScoreChord::copy() const {
  return new ScoreChord();
}

void ScoreChord::paint(PrScoreEditor * ed, int x, int y, int) {
  factory->getScorePainter()->paintChord(this, ed, &_notes, x, y);
}

void ScoreChord::print(PrScoreEditor * ed, int x, int y) {
  factory->getScorePrinter()->paintChord(this, ed, &_notes, x, y);
}



#endif

