#ifndef _SCORETRACK_CPP_
#define _SCORETRACK_CPP_

#include <iostream.h>
#include <stdlib.h>
#include "scoreTrack.h"
#include "loader.h"
#include "table.h"
#include "str.h"
#include "prFactory.h"
#include "prTrack.h"
#include "song.h"
#include "player.h"

extern Song * sonG;
extern PrFactory * factory;

ScoreTrack::ScoreTrack()
  : Track(), _channel(0), _program(0), _output(0), _volume(0), _delay(0), _transpose(0),
    _print_in_partiture(true), _print_in_piano_system(0)
{
  _type = SCORETRACK;
  _pr = factory->createScoreTrack(this);
}

ScoreTrack::ScoreTrack(const ScoreTrack& st)
  : Track(st,SCORETRACK)
{
    _channel = st.channel();
    _program = st.program();
    _output = st.output();
    _volume = st.volume();
    _delay = st.delay();
    _transpose = st.transpose();
    _print_in_partiture = st.PiP();
    _print_in_piano_system = st.PiPS();
    _pr = factory->createScoreTrack(this);
}

ScoreTrack::~ScoreTrack() {
}

void ScoreTrack::setChannel(int i) {
  _channel = i;
}

void ScoreTrack::setProgram(int i) {
  _program = i;
  sonG->player()->programChange(this);
}

void ScoreTrack::setOutput(int i) {
  _output = i;
}

void ScoreTrack::setVolume(int i) {
  _volume = i;
}

void ScoreTrack::setDelay(int i) {
  _delay = i;
}

void ScoreTrack::setTranspose(int i) {
  _transpose = i;
}

/*
void ScoreTrack::hide() {
  cout << "ScoreTrack::hide" << endl;
}

void ScoreTrack::show() {}
*/

ostream & ScoreTrack::printOptions(int dep, ostream & s) const {
  s << spc(dep) << "<OPTIONS ";
  s << " program=\"" << _program << "\"";
  s << " channel=\"" << _channel << "\"";
  s << " output=\"" << _output << "\"";
  s << " volume=\"" << _volume << "\"";
  s << " transpose=\"" << _transpose << "\"";
  s << " delay=\"" << _delay << "\"";
  // s << " print=\"" << str->PiP() << "\"";
  // s << " printps=\"" << str->PiPS() << "\"";
  s << " />" << endl;
  return s;
}

void ScoreTrack::flush(const char * c) const {
  cout << c << "SCORETRACK" << endl;
}

Element * ScoreTrack::copy() const {
  return new ScoreTrack(*this);
}


/* <TRACK type="0" name="Sopran" mute="0" lock="0" >
<OPTIONS program="0" channel="0" output="2" volume="0" transpose="0" delay="0" />
*/

void ScoreTrack::loadOpt(ifstream *& inPtr) {
  Table * opt = Loader::getAttributes("OPTIONS",inPtr);
  int program = 0;
  int channel = 0;
  int output = 0;
  int volume = 0;
  int transpose = 0;
  int delay = 0;
  if (opt->getEntry("program")) program = atoi(((String*) opt->getEntry("program"))->getValue());
  if (opt->getEntry("channel")) channel = atoi(((String*) opt->getEntry("channel"))->getValue());
  if (opt->getEntry("output")) output = atoi(((String*) opt->getEntry("output"))->getValue());
  if (opt->getEntry("volume")) volume = atoi(((String*) opt->getEntry("volume"))->getValue());
  if (opt->getEntry("transpose")) transpose = atoi(((String*) opt->getEntry("transpose"))->getValue());
  if (opt->getEntry("delay")) delay = atoi(((String*) opt->getEntry("delay"))->getValue());
  setProgram(program);
  setChannel(channel);
  setOutput(output);
  setVolume(volume);
  setTranspose(transpose);
  setDelay(delay);
  opt->scratch();
  delete opt;
}

/* printing: */
void ScoreTrack::sPiP(bool p) { _print_in_partiture = p; }

void ScoreTrack::sPiPS(int p) { _print_in_piano_system = p; }


#endif
