#ifndef _SELECTRIGHT_H_
#define _SELECTRIGHT_H_

#include "operation.h"
#include "position.h"

class Element;
class Compound;
class Table;
class Reference;
class Part;

/** This operation adds an element to a compound. In case the operation is undone, the element has to be deleted when the operation-instance is deleted.
 * For this reason, a _delete element is used...
 */
class SelectRight : public Operation
{
 private:
  Part * _part;
  Table * _oldTable;
  Table * _delete;
  int _size;

 public:
  SelectRight(Part * pt, Position left = 0);
  SelectRight(const SelectRight&);
  ~SelectRight();

  void undo();
  void redo();


  virtual ostream & print(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;
};



#endif
