#ifndef _SAMPLEEDITOR_CPP_
#define _SAMPLEEDITOR_CPP_


#include <stdlib.h>
#include <stdio.h>
#include <iostream.h>
#include <math.h>

#include <qsplitter.h>
#include <qpushbutton.h>
#include <qscrollview.h>
#include <qframe.h>
#include <qstring.h>

#include "part.h"
#include "track.h"
#include "vector.h"
#include "str.h"
#include "event.h"
#include "song.h"
#include "note.h"
#include "position.h"
#include "addElement.h"

#include "kdeSampleEditor.h"
#include "kdeSampleContent.h"
#include "kdeProgress.h"
#include "kdeEditorToolBar.h"
#include "kdeEditorNoteBar.h"
#include "kdeEditorButtonBar.h"
#include "kdeEditorScrollBar.h"
#include "kdeEditInfo.h"
#include "kdeEditorMenuBar.h"
#include "brahmsResources.h"

extern Song * sonG;

KdeSampleEditor::KdeSampleEditor() : KMainWindow(0L, "SampleEditor"), PrPartEditor(PREDITOR) {
  run();
}

KdeSampleEditor::KdeSampleEditor(Part * p) : KMainWindow(0L, "SampleEditor"), PrPartEditor(p) {
  run();
}

KdeSampleEditor::KdeSampleEditor(Track * t) : KMainWindow(0L, "SampleEditor"), PrPartEditor(t) {
  run();
}

KdeSampleEditor::~KdeSampleEditor() {

}

void KdeSampleEditor::run() {

  QString pname = QString("");
  Track * tr = part()->track();
  if (tr!=0) pname = QString(tr->name()->getValue());
  QString capt = QString("SampleEditor - " + pname);
  setCaption(capt);

  _ybottom = 20 + 4*14*8;
  _grid_id = ID_GRID_4;
  _dyn_id = ID_DYN_F;
  _toolbarstate = true;
  _notebarstate = false;
  _buttonbarstate = true;
  _sliderstate = true;

  //
  // Toolbars:
  // =========

  _toolbar = new KdeEditorToolBar(this,this);
  _notebar = new KdeEditorNoteBar(this,this);
  _buttonbar = new KdeEditorButtonBar(this,this);
  _scrollbar = new KdeEditorScrollBar(this,this);


  addToolBar( _toolbar ); _toolbar->setBarPos(KToolBar::Top); if (_toolbarstate) _toolbar->show(); else _toolbar->hide();
  addToolBar( _notebar ); _notebar->setBarPos(KToolBar::Top); if (_notebarstate) _notebar->show(); else _notebar->hide();
  addToolBar( _buttonbar ); _buttonbar->setBarPos(KToolBar::Top); if (_buttonbarstate) _buttonbar->show(); else _buttonbar->hide();
  addToolBar( _scrollbar ); _scrollbar->setBarPos(KToolBar::Bottom); if (_sliderstate) _scrollbar->show(); else _scrollbar->hide();


  //
  // Menubar:
  // ========
  //

  _filemenu = new QPopupMenu( this );
  _editmenu = new QPopupMenu( this );
  _gridmenu = new QPopupMenu( this );
  _dynamicsmenu = new QPopupMenu( this );
  _viewmenu = new QPopupMenu( this );
  KdeEditorMenuBar::createMenuBar(menuBar(), _filemenu, _editmenu, _gridmenu, _dynamicsmenu, _viewmenu);
  _gridmenu->setItemChecked(_grid_id,TRUE);
  _dynamicsmenu->setItemChecked(_dyn_id,TRUE);
  _viewmenu->setItemChecked(ID_VIEW_TOOLBAR, _toolbarstate);
  _viewmenu->setItemChecked(ID_VIEW_NOTEBAR , _notebarstate);
  _viewmenu->setItemChecked(ID_VIEW_BUTTONBAR, _buttonbarstate);
  _viewmenu->setItemChecked(ID_VIEW_SLIDER, _sliderstate);
  connect(_filemenu,SIGNAL(activated(int)),SLOT(slotMenu(int)));
  connect(_editmenu,SIGNAL(activated(int)),SLOT(slotMenu(int)));
  connect(_gridmenu,SIGNAL(activated(int)),SLOT(slotGridMenu(int)));
  connect(_dynamicsmenu,SIGNAL(activated(int)),SLOT(slotDynMenu(int)));
  connect(_viewmenu,SIGNAL(activated(int)),SLOT(slotViewMenu(int)));



  //
  // Contents:
  // =========


  _splitter = new QSplitter(Qt::Vertical,this);

  _scroller = new QScrollView( _splitter, "Scroller", QFrame::Raised );
  _scroller->setHScrollBarMode(QScrollView::AlwaysOff);
  _scroller->setVScrollBarMode(QScrollView::AlwaysOn);
  

  _content = new KdeSampleContent( _scroller, this, _toolbar, _notebar, _buttonbar );
  _content->setBackgroundMode( QWidget::PaletteLight );
  _scroller->addChild(_content);

  _info = new KdeEditInfo( _splitter, this );
  _info->setBackgroundMode( QWidget::PaletteMidlight );

  setCentralWidget(_splitter);
  _content->setGeometry(0,0,width()-20, _ybottom);
  _info->setGeometry(0,0,width(),120);
  _splitter->setMaximumHeight(_ybottom);
  
  update();
  sonG->updateGui();
  setFocus();
}

void KdeSampleEditor::resizeEvent( QResizeEvent * ) {
  _content->setGeometry(0,0,width()-20, _ybottom);
  _splitter->setMaximumHeight(_ybottom);
}

void KdeSampleEditor::update() {
  _content->repaint(FALSE);
  _info->repaint(FALSE);
  _buttonbar->setLength(lengthOrd(),dot(),tuplet()>0);
  /* switch (lengthOrd()) {
  case 1: slotGridMenu(ID_GRID_1); break;
  case 2: slotGridMenu(ID_GRID_2); break;
  case 3: slotGridMenu(ID_GRID_4); break;
  case 4: slotGridMenu(ID_GRID_8); break;
  case 5: slotGridMenu(ID_GRID_16); break;
  case 6: slotGridMenu(ID_GRID_32); break;
  case 7: slotGridMenu(ID_GRID_64); break;
  default: slotGridMenu(ID_GRID_OFF); break;
  }*/
}

void KdeSampleEditor::gui(GuiEvents ev, bool flag) {
  switch (ev) {
  case CHANGES:
    break;
  case UNDO:
    _toolbar->setItemEnabled( ID_EDIT_UNDO, flag );
    _editmenu->setItemEnabled( ID_EDIT_UNDO, flag );
    break;
  case REDO:
    _toolbar->setItemEnabled( ID_EDIT_REDO, flag );
    _editmenu->setItemEnabled( ID_EDIT_REDO, flag );
    break;
  case SELECTIONS:
    _toolbar->setItemEnabled( ID_EDIT_CUT, flag );
    _toolbar->setItemEnabled( ID_EDIT_COPY, flag );
    _toolbar->setItemEnabled( ID_EDIT_CLEAR, flag );
    _toolbar->setItemEnabled( ID_EDIT_TRANSPOSE, flag );
    _editmenu->setItemEnabled( ID_EDIT_CUT, flag );
    _editmenu->setItemEnabled( ID_EDIT_COPY, flag );
    _editmenu->setItemEnabled( ID_EDIT_CLEAR, flag );
    _editmenu->setItemEnabled( ID_EDIT_TRANSPOSE, flag );
    _editmenu->setItemEnabled( ID_EDIT_QUANTIZE_ALL, flag );
    _editmenu->setItemEnabled( ID_EDIT_QUANTIZE_LENGTH, flag );
    _editmenu->setItemEnabled( ID_EDIT_FIXED_LENGTH, flag );
    break;
  case MEMORY:
    _toolbar->setItemEnabled( ID_EDIT_PASTE, flag );
    _editmenu->setItemEnabled( ID_EDIT_PASTE, flag );

    break;
  }
}

void KdeSampleEditor::print() {
}

void KdeSampleEditor::settings() {
}


void KdeSampleEditor::slotMenu(int i) {
  _toolbar->commandCallback(i);
}

void KdeSampleEditor::slotGridMenu(int i) {
  _gridmenu->setItemChecked(_grid_id,false);
  _grid_id = i;
  _gridmenu->setItemChecked(_grid_id,true);
  switch (i) {
  case ID_GRID_1: setGrid(1536); break;
  case ID_GRID_2: setGrid(768); break;
  case ID_GRID_4: setGrid(384); break;
  case ID_GRID_8: setGrid(192); break;
  case ID_GRID_16: setGrid(96); break;
  case ID_GRID_32: setGrid(48); break;
  case ID_GRID_64: setGrid(24); break;
  case ID_GRID_OFF: setGrid(0); break;
  }
}

void KdeSampleEditor::slotDynMenu(int i) {
  _dynamicsmenu->setItemChecked(_dyn_id,false);
  _dyn_id = i;
  _dynamicsmenu->setItemChecked(_dyn_id,true);
  switch (i) {
  case ID_DYN_OFF: setVelocity(0); break;
  case ID_DYN_P: setVelocity(14); break;
  case ID_DYN_PP: setVelocity(28); break;
  case ID_DYN_PPP: setVelocity(42); break;
  case ID_DYN_MP: setVelocity(56); break;
  case ID_DYN_MF: setVelocity(70); break;
  case ID_DYN_F: setVelocity(86); break;
  case ID_DYN_FF: setVelocity(102); break;
  case ID_DYN_FFF: setVelocity(127); break;
  default: setVelocity(0); break;
  }
}

void KdeSampleEditor::slotViewMenu(int i) {
  bool ch = _viewmenu->isItemChecked(i);
  ch = !ch;
  _viewmenu->setItemChecked(i,ch);
  switch(i) {
  case ID_VIEW_TOOLBAR:
    if (ch) _toolbar->show(); else _toolbar->hide();
    break;
  case ID_VIEW_NOTEBAR:
    if (ch) _notebar->show(); else _notebar->hide();
    break;
  case ID_VIEW_BUTTONBAR:
    if (ch) _buttonbar->show(); else _buttonbar->hide();
    break;
  case ID_VIEW_SLIDER:
    if (ch) _scrollbar->show(); else _scrollbar->hide();
    break;
  }
}

void KdeSampleEditor::keyPressEvent ( QKeyEvent * key ) {
  _content->keyPressEvent(key);
}

void KdeSampleEditor::keyReleaseEvent ( QKeyEvent * key ) {
  _content->keyReleaseEvent(key);
}

void KdeSampleEditor::paintEvent( QPaintEvent * ) {
  _content->repaint(FALSE);
  _info->repaint(FALSE);
}

void KdeSampleEditor::setCursorPosition(long ticks) {
  _content->moveCursor(ticks);
}



#endif
#include "kdeSampleEditor.moc"
