#ifndef _TEXTMAINEDITOR_CPP_
#define _TEXTMAINEDITOR_CPP_

#include <stdlib.h>
#include <string.h>
#include <iostream.h>
#include <math.h>

#include "song.h"
#include "scoreTrack.h"
#include "drumTrack.h"
#include "masterTrack.h"
#include "audioTrack.h"
#include "commentTrack.h"
#include "part.h"
#include "addElement.h"
#include "removeElement.h"
#include "convertTrack.h"
#include "vector.h"
#include "str.h"
#include "note.h"
#include "loader.h"
#include "prTrack.h"
#include "player.h"

#include "textMainEditor.h"
#include "textFactory.h"
#include "textPartEditor.h"
#include "textScoreEditor.h"
#include "textProgress.h"
#include "textTrack.h"


extern Song * sonG;

TextMainEditor::TextMainEditor(int argc, char ** argv) : PrMainEditor(argc,argv), _argc(argc), _argv(argv), _editor_type(SCOREEDITOR) {
}

void TextMainEditor::run() {
  loadSong(_argc,_argv);

  char line[400];
  const char * cmd;
  bool exit = false;
  bool debug = false;

  update();
  while (!exit) {
#ifdef DEBUGIT
    cout << "[ " << sonG->total() << " ] $ ";
#else
    cout << "$ ";
#endif
    cin.getline(line,400,'\n');
    Vector vec = Vector(line);
    cmd = ((String*) (vec)[0])->getValue();
    // if (vec[0]=="hallo") cout << "ok" << endl;
    if (debug) cout << vec << endl;
    else if (strcmp(cmd,"")==0) { update(); }
    else if (strcmp(cmd,"help")==0) {
      cout << "help            - shows this list" << endl;
      cout << "actions         - lists the available actions" << endl;
      cout << "copy            - copies the song (test)" << endl;
      cout << "list            - lists the song" << endl;
      cout << "debug           - switches debug mode on and off" << endl;
      cout << "add scoretrack  - adds a track to the song" << endl;
      cout << "add drumtrack   - adds a track to the song" << endl;
      cout << "add mastertrack - adds a track to the song" << endl;
      cout << "add audiotrack  - adds a track to the song" << endl;
      cout << "add texttrack   - adds a track to the song" << endl;
      cout << "add part n      - adds a part to track n" << endl;
      cout << "add note n m    - adds a note to part n, track m" << endl;
      cout << "   [pos pitch len vel]" << endl;
      cout << "del <trnum>     - delete track <trnum> from the song" << endl;
      cout << "type <trnum> n  - changes the type of track <trnum>" << endl;
      cout << "oplist          - lists the operations in the stack of the song" << endl;
      cout << "undo            - undoes one operation" << endl;
      cout << "redo            - redoes one operation" << endl;
      cout << "dump            - dumps all elements" << endl;
      cout << "clear           - delete song" << endl;
      cout << "load <fname>    - load a song" << endl;
      cout << "save <fname>    - save a song" << endl;
      cout << "im   <fname>    - load a midi song" << endl;
      cout << "play            - play song" << endl;
      cout << "edit n          - edit track n" << endl;
      cout << "set <editor>    - sets the editor (Score, PianoRoll)" << endl;
      cout << "tempo n         - sets the tempo" << endl;
    }
    else if (strcmp(cmd,"exit")==0) exit = true;
    else if (strcmp(cmd,"copy")==0) {
      // Track * tr = (Track*) sonG->get(0)->copy();
      Song * s1 = (Song*) sonG->copy();
    }
    else if (strcmp(cmd,"clear")==0) { delete sonG; sonG = 0; }
    else if (strcmp(cmd,"list")==0) { cout << *sonG << endl; }
    else if (strcmp(cmd,"debug")==0) { if (debug) { debug = false; } else { cout << vec << endl; debug = true; } }
    else if (strcmp(cmd,"undo")==0) { sonG->undo(); }
    else if (strcmp(cmd,"play")==0) { sonG->play(); }
    else if (strcmp(cmd,"set")==0) {
      const char * par = ((String*) (vec)[1])->getValue();
      if (strcmp(par,"Score")==0) { _editor_type = SCOREEDITOR; }
      if (strcmp(par,"PianoRoll")==0) { _editor_type = PREDITOR; }
      update();
    }
    else if (strcmp(cmd,"edit")==0) {
      int par = atoi(((String*) (vec)[1])->getValue()) - 1; // track
      Track * tr = (Track*)sonG->get(par);
      if (tr) {
	PrPartEditor * pe = 0;
	if      (_editor_type==SCOREEDITOR) pe = new TextScoreEditor(tr);
	else if (_editor_type==PREDITOR) pe = new TextPartEditor(tr);
	delete pe;
	update();
      }
    }
    else if (strcmp(cmd,"tempo")==0) {
      int par = atoi(((String*) (vec)[1])->getValue());
      if (par > 20 && par < 1000) sonG->setTempo(par);
    }
    else if (strcmp(cmd,"load")==0) {
      const char * par1 = ((String*) (vec)[1])->getValue();
      if (par1!=0) {
	if (sonG!=0) delete sonG;
	sonG = Loader::load((char*)par1,new TextProgress(10));
	cout << endl;
      }
    }
    else if (strcmp(cmd,"im")==0) {
      const char * par1 = ((String*) (vec)[1])->getValue();
      if (par1!=0) {
	if (sonG!=0) delete sonG;
	sonG = Loader::loadMidi((char*)par1,new TextProgress(10));
	cout << endl;
      }
    }
    else if (strcmp(cmd,"save")==0) {
      const char * par1 = ((String*) (vec)[1])->getValue();
      if (par1!=0) {
	Loader::save((char*)par1,sonG);
      }
    }
    else if (strcmp(cmd,"oplist")==0) { sonG->oplist(); }
    else if (strcmp(cmd,"redo")==0) { sonG->redo(); }
#ifdef DEBUGIT
    else if (strcmp(cmd,"dump")==0) {
      int num = vec.size();
      if (num>1) {
	int par = atoi(((String*) (vec)[1])->getValue());
	sonG->dump(par);
      } else
	sonG->dump();
    }
#endif
    else if (strcmp(cmd,"del")==0) {
      int par = atoi(((String*) (vec)[1])->getValue());
      Track * tr = (Track*) sonG->get(par);
      sonG->doo(new RemoveElement(tr,sonG));
    }
    else if (strcmp(cmd,"type")==0) {
      int par1 = atoi(((String*) (vec)[1])->getValue());
      int par2 = atoi(((String*) (vec)[2])->getValue());
      Track * tr = (Track*) sonG->get(par1);
      if ((tr!=0)&&(par2>-1)&&(par2<6))
	sonG->doo(new ConvertTrack(par2,tr,sonG));
    }
    else if (strcmp(cmd,"add")==0) {
      const char * par1 = ((String*) (vec)[1])->getValue();
      if (strcmp(par1,"st")==0) {
	sonG->doo(new AddElement(new ScoreTrack(),sonG));
	cout << "added scoretrack to song" << endl;
      } else if (strcmp(par1,"drumtrack")==0) {
	sonG->doo(new AddElement(new DrumTrack(),sonG));
	cout << "added drumtrack to song" << endl;
      } else if (strcmp(par1,"mastertrack")==0) {
	sonG->doo(new AddElement(new MasterTrack(),sonG));
	cout << "added mastertrack to song" << endl;
      } else if (strcmp(par1,"audiotrack")==0) {
	sonG->doo(new AddElement(new AudioTrack(),sonG));
	cout << "added audiotrack to song" << endl;
      } else if (strcmp(par1,"texttrack")==0) {
	sonG->doo(new AddElement(new CommentTrack(),sonG));
	cout << "added texttrack to song" << endl;
      } else if (strcmp(par1,"part")==0) {
	int par2 = atoi(((String*) (vec)[2])->getValue()) - 1;
	if (par2<0) par2 = 0;
	Track * tr = (Track*)sonG->get(par2);
	if (tr) {
	  Part * pt = new Part(tr);
	  pt->setMeter(sonG->meter0(),sonG->meter1());
	  sonG->doo(new AddElement(pt,tr));
	  cout << "added part to track " << par2+1 << endl;
	} else cout << "*** no tracks" << endl;
      } else if (strcmp(par1,"note")==0) {
	int par2 = atoi(((String*) (vec)[2])->getValue()) - 1; // part
	int par3 = atoi(((String*) (vec)[3])->getValue()) - 1; // track
	// pitch, vel, len, pos, enh
	int pitch = 76;
	int vel = 86;
	int len = 192;
	int pos = 0;
	int enh = 0;
	int num = vec.size();
	cout << "num: " << num << endl;
	if (num>4) { pos = atoi(((String*) (vec)[4])->getValue()); }
	if (num>5) { pitch = atoi(((String*) (vec)[5])->getValue()); }
	if (num>6) { len = atoi(((String*) (vec)[6])->getValue()); }
	if (num>7) { vel = atoi(((String*) (vec)[7])->getValue()); }
	if (par2<0) par2 = 0;
	if (par3<0) par3 = 0;
	Track * tr = (Track*)sonG->get(par3);
	if (tr) {
	  Part * pt = (Part*)tr->get(par2);
	  if (pt) {
	    // Note * n = new Note(pitch, vel, len, Position(pos), enh);
	    Note * n = new Note();
	    sonG->doo(new AddElement(n,pt));
	    cout << "added note to part " << par2+1 << " of track " << par3+1 << endl;
	  } else cout << "*** no parts" << endl;
	} else cout << "*** no tracks" << endl;
      }
    } else if (strcmp(cmd,"actions")==0) {
      char ** al = actionList();
      for (int i=0;al[i]!=0;i++)
	cout << al[i] << endl;
    } else {
      if (strlen(line)>0) {
	cout << "... delegating to shell" << endl;
	system(line);
      }
    }
  }
  
}

void TextMainEditor::update() {
  char ** alist = actionList();

  // cout << "\ec" << endl;
  cout << "Welcome to the Brahms text console\n" << endl;
  if (sonG) {
    // cout << sonG << endl;
    cout << "Title: " << sonG->title() << " (" << sonG->author() << ", " << sonG->comment() << ")" << endl;
    cout << "(v" << sonG->version() << ")" << endl;
    cout << "Tempo: " << sonG->tempo() << "  Meter: " << sonG->meter0() << "/" << sonG->meter1() << endl;
    cout << "Undo: " << sonG->undoList()->size() << ", redo: " << sonG->redoList()->size() << endl;
    // cout << "Adons: ";
    // for (int i=0;alist[i]!=0;i++) cout << alist[i] << " ";
    cout << "Editor: ";
    switch (_editor_type) {
    case SCOREEDITOR: cout << "Score"; break;
    case PREDITOR: cout << "PianoRoll"; break;
    }
    cout << endl;
    cout << endl;
    int imax = sonG->size();
    Track * tr = 0;
    Part * pt = 0;
    for (int i=0; i<imax; i++) {
      tr = (Track*) sonG->get(i);
      // if (!((TextTrack*)tr->presentation())->hidden()) {
      cout << "Track " << i+1 << " (" << tr->ctype() << ") : ";
	int kmax = tr->size();
	for (int k=0; k<kmax; k++) {
	  // for (Part * pt = (Part*) tr->first(); pt != 0; pt = (Part*) Element::next(pt)) {
	  pt = (Part*) tr->get(k);
	  int len = pt->size();
	  cout << "[Part " << k+1 << ", " << len << " events] ";
	}
	cout << endl;
	//}
    }
  } else {
    cout << "no song in memory" << endl;
  }
  cout << endl;
}

void TextMainEditor::gui(GuiEvents e, bool b) {
  cout << "GUI: " << e << ", " << b << endl;

}

void TextMainEditor::fatalError(FatalError error) {
  cout << "An error occured during aRts initialization (" << error << endl;
  cout << "Make sure artsd is running and installed properly" << endl;
  exit(1);
}

void TextMainEditor::startTimer() {
  bool stop = false;
  bool _cycl = false;
  while (!stop) {
    stop = (!sonG->player()->playQuantum(_cycl));
  }
  sonG->player()->killAllNotes();
}


#endif
