#ifndef _TABLE_H_
#define _TABLE_H_

#include "compound.h"

/** the table is thought to contain references. It has an own scratch() implementation
*/
class Table : public Compound
{
 private:

 public:
  Table();
  Table(const Table&);

  // void add(Element*,Element*);
  Element * operator[](Element*);
  Element * getEntry(const char*);
  void removeEntry(Element*);
  void deleteEntry(Element*);
  bool hasEntry(Element*);

  /** walks through the table and deletes each entry. If an entry is a reference, it deletes key as well as value (if not null).
   */
  void scratch();

  virtual ostream & print(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;

};

#endif
