
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nick.copeland@ntlworld.com> 1996,2002
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "brightonX11internals.h"

/*
 * At the moment (14/3/02) this code uses XDrawPoint directly onto the screen.
 * It could be accelerated by using an XImage structure. In the mean time this
 * will be accelerated using XDrawPoints() rather than the singular version.
 */
BCopyArea(brightonDisplay *display, int x, int y, int w, int h, int dx, int dy)
{
	bdisplay *bd = display->display;

//printf("BCopyArea(%x %x, (%i/%i/%i/%i) (%i/%i/%i,%i) %x\n",
//bd, display->image, x, y, w, h, dx, dy, bd->width, bd->height, bd->gc);

	if (display->image)
		XCopyArea(bd->display, (Pixmap) display->image,
			(Window) ((brightonWindow *) display->bwin)->win,
			(GC) ((brightonWindow *) display->bwin)->gc,
				x, y, w, h, dx, dy);
}

BResizeWindow(brightonDisplay *display, brightonWindow *bwin,
int width, int height)
{
	bdisplay *bd = display->display;

//printf("BResizeWindow(%x, %x, %i, %i)\n", display, bwin, width, height);

	XResizeWindow(bd->display, (Window) bwin->win, width, height);
}

BDrawArea(brightonDisplay *display, register brightonBitmap *bitmap,
register int sx, register int sy, register int sw, register int sh,
register int destx, register int desty)
{
	register bdisplay *bd = display->display;
	register brightonWindow *bwin = (brightonWindow *) display->bwin;
	register brightonQRender *qrender = bd->qrender;
	register brightonPalette *palette = display->palette;
	register brightonDisplay *bdisplay = bwin->display;
	register int *pixels = bitmap->pixels, ncolors = bd->ocount, cindex;
	register int missed = 0;
	register GC tgc;
	register int x, y, index;
	register int dx, dy = desty;

//printf("BDrawArea(%x %x, (%i/%i/%i/%i) (%i/%i) (%i/%i) %i\n",
//bwin, bitmap, sx, sy, sw, sh, destx, desty, bd->width, bd->height, bd->depth);

	if (qrender == 0)
	{
		qrender = (brightonQRender *)
			brightonX11malloc(BRIGHTON_QR_COLORS * sizeof(brightonQRender));
		bd->qrender = qrender;
		ncolors = bd->ocount = BRIGHTON_QR_COLORS;
	}

	if (display->image == 0)
	{
		bd->width = ((brightonWindow *) display->bwin)->width;
		bd->height = ((brightonWindow *) display->bwin)->height;

		display->image = (void *) XCreatePixmap(bd->display, (Window) bwin->win,
			bd->width, bd->height, bd->depth);
	} else {
		if ((bd->width != ((brightonWindow *) display->bwin)->width)
			|| (bd->height != ((brightonWindow *) display->bwin)->height))
		{
			XFreePixmap(bd->display, (Pixmap) display->image);
//printf("new pixmap %i,%i %i,%i\n", bd->width, bd->height,
//((brightonWindow *) display->bwin)->width,
//((brightonWindow *) display->bwin)->height);

			bd->width = ((brightonWindow *) display->bwin)->width;
			bd->height = ((brightonWindow *) display->bwin)->height;

			display->image = (void *) XCreatePixmap(bd->display,
				(Window) bwin->win, bd->width, bd->height, bd->depth);
		}
	}

	/*
	 * We now go through each bit in the bitmap, check we have its color, and
	 * then render it onto the pixmap. After that we copy the relevant area
	 * of the pixmap over to the screen.
	 */
	for (y = sy; y < (sy + sh); y++)
	{
		if (y >= bitmap->height)
			break;

		dx = destx;

		for (x = sx; x < (sx + sw); x++)
		{
			if (x >= bitmap->width)
				break;

			index = y * bitmap->width + x;

			/*
			 * Do not render blue
			 */
			if ((palette[pixels[index]].red == 0) 
				&& (palette[pixels[index]].green == 0)
				&& (palette[pixels[index]].blue == 65535))
			{
				++dx;
				continue;
			}

			if (palette[pixels[index]].gc == 0)
			{
				/*
				 * Get a GC
				 */
				BAllocColor(display, &palette[pixels[index]],
					palette[pixels[index]].red,
					palette[pixels[index]].green,
					palette[pixels[index]].blue);
			}

			tgc = palette[pixels[index]].gc;
			for (cindex = 0; cindex < ncolors; cindex++)
			{
				if (qrender[cindex].gc == tgc)
					break;
				if (qrender[cindex].gc == 0)
				{
					/* 
					 * We have not filled this queue yet.
					 */
					qrender[cindex].gc = tgc;
					qrender[cindex].index = index;
					break;
				}
			}

			if (cindex == ncolors) {
				missed++;
				XDrawPoint(bd->display, (Pixmap) display->image,
					(GC) palette[pixels[index]].gc, dx, dy);
			} else {
				qrender[cindex].queue[qrender[cindex].count].x = dx;
				qrender[cindex].queue[qrender[cindex].count].y = dy;
				if (++qrender[cindex].count == BRIGHTON_QR_QSIZE)
				{
					XDrawPoints(bd->display, (Pixmap) display->image,
						tgc, qrender[cindex].queue, BRIGHTON_QR_QSIZE,
						CoordModeOrigin);
					qrender[cindex].count = 0;
				}
			}

			++dx;
		}

		++dy;
	}

	for (cindex = 0; cindex < ncolors; cindex++)
	{
		if (qrender[cindex].count == 0)
			continue;

		XDrawPoints(bd->display, (Pixmap) display->image,
			qrender[cindex].gc, qrender[cindex].queue,
			qrender[cindex].count, CoordModeOrigin);

		qrender[cindex].count = 0;
	}

	if (missed)
	{
		brightonX11free(bd->qrender);
		bd->ocount += BRIGHTON_QR_COLORS;

		bd->qrender = (brightonQRender *)
			brightonX11malloc(bd->ocount * sizeof(brightonQRender));
printf("Allocated %i colors (%i)\n", ncolors, bd->ocount);
	}
	BCopyArea(display, destx, desty, sw, sh, destx, desty);
}

