
/*
 *  Diverse SLab audio routines.
 *  Copyright (c) by Nick Copeland <nick.copeland@ntlworld.com> 1996,2002
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#include <string.h>

#include "slabrevisions.h"
#include "slabaudiodev.h"

duplexDev audioDev;

main()
{
	strcpy(&audioDev.devName[0], "0");
	strcpy(&audioDev.mixerName[0], "0");

	audioDev.siflags = AUDIO_ALSA;

	mixerOpen(&audioDev);
	mixerClose(&audioDev);
return;
	setMute(&audioDev, 0);
	setVol(&audioDev, 100);
}

setVol(audioDev, value)
duplexDev *audioDev;
{
	int k;

	mixerOpen(audioDev);

	for (k = 0; k < 11; k++)
	{
		setAudioValue(audioDev, k, 1, value);
		usleep(20000);
		setAudioValue(audioDev, k, 2, value);
		usleep(20000);
	}

	mixerClose(audioDev);
}

setMute(audioDev, value)
duplexDev *audioDev;
{
	int k;

	mixerOpen(audioDev);

	for (k = 0; k < 11; k++)
	{
		setAudioMute(audioDev, k, value);
		usleep(20000);
	}

	mixerClose(audioDev);
}

setVal(audioDev, value)
duplexDev *audioDev;
{
	mixerOpen(audioDev);

	setAudioValue(audioDev, 7, 1, value);

	mixerClose(audioDev);
}

