/*

  IMHO_CATALA  v 0.1 - Language module for IMHO
  IMHO - webmail module for Roxen

  
  Copyright  
  Slvia Penas <silviap@asic.UdL.es>
  & Carles Mateu <carlesm@asic.udl.es> 1999-2000
  
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  See the file "LICENSE" for details.

*/

#include <camas/language.h>

string imho_lang() {
  return "catal";
}

string imho_lang_short() {
  return "ct";
}

string imho_lang_charset() {
  return "iso-8859-1";
}

string imho_lang_replacement_string() {
  //this is a UNICODE string that MUST be encodable by the local charset
  return "";
}

string msg(object sessobj,int m,array arg) {
  switch(m) {
    
    // Login page
    
  case M_LOGIN:
    //return "Login:";
    return "Login:";
  case M_PASSWORD:
    //return "Password:";
    return "Clau:";
  case M_NOLOGIN:
    //return "<b>Could not log in:</b> Wrong login or password. Try again. ";
    return "<b>No s'ha pogut entrar:</b> Login o clau incorrecta. Prova de nou. ";
  case M_IMAPERROR:
    //return "There was a problem talking to the mail (IMAP) server. Please contact the administrator.";
    return "Hi ha hagut problemes comunicant amb el servidor de correu (IMAP). Contacteu amb els responsables.";
  case M_SMTPERROR:
    //return "There was a problem talking to the outgoing mail (SMTP) server. The recipient of the mail might not exist.";
    return "Hi ha hagut problemes contactant amb el servidor de correu sortint (SMTP). El destinatari del correu podria no existir.";
  case M_SAVEDUSERINTERFACE:
    //return "From preferences";
    return "De les preferncies";
  case M_USERINTERFACE:
    //return "User interface:";
    return "Interfcie d'usuari:";
  case M_LOGIN_OK:
    //return "OK";
    return "OK";

  case M_NEWMAIL:
    //return "Compose";
    return "Correu Nou";
  case M_MAILBOX:
    //return sprintf("Mailbox: %s",@arg);
    return sprintf("Bstia: %s",@arg);
  case M_MAILBOXES:
    //return "Mailboxes";
    return "Bsties";
  case M_FILES:
    //return "Files";
    return "Fitxers";
  case M_PREFS:
    //return "Preferences";
    return "Preferncies";
  case M_LOGOUT:
    //return "Logout";
    return "Sortir";
  case M_CURRMAILBOX:
    // return "Current Mailbox";
    return "Bstia Actual";
  case M_CHECKACTIVEMAILBOXES:
    // return "Check active mailboxes";
    return "Provar Bsties Actives";

  case M_FROM:
    //return "From";
    return "De";
  case M_TO:
    //return "To";
    return "A";
  case M_CC:
    //return "Cc";
    return "Cc";
  case M_BCC:
    //return "Bcc";
    return "Bcc";
  case M_SUBJECT:
    //return "Subject";
    return "Tema";
  case M_ATTACHMENTS:
    //return "Attachments";
    return "Adjunts";
  case M_TIME:
    //return "Time";
    return "Hora";
  case M_DATE:
    //return "Date";
    return "Data";
    
  case  M_MARKFLAG:
    //return "M";
    return "M";
  case M_NEWFLAG:
    //return "N";
    return "N";
  case M_ANSWEREDFLAG:
    //return "A";
    return "R";
    
    
  case M_SEND:
    //return "Send";
    return "Enviar";
  case M_CANCELSEND:
    //return "Cancel";
    return "Cancellar";
  case M_SENDMOREFILES:
    //return "Select files to send. Press 'Ctrl' to toggle-select multiple files.";
    return "Seleccioneu els fitxers per enviar. Premeu 'Ctrl' per selecci multiple.";
  case M_COMPOSEMAIL:
    //return "Compose mail";
    return "Escriure correu";
  case M_SPELLCHECK:
    return "Revisi ortogrfica";
  case M_DONTSAVEMAIL:
    //return "Do not save this mail.";
    return "No salvar aquest missatge.";
  case M_ADDFILEASATTACHMENT:
    //return "Add file as attachment";
    return "Afegir fitxer com adjunt";
  case M_NOATTACHMENTS:
    //return "No attachments";
    return "Sense Adjunts";
  case M_ADDATTACHMENT:
    //return "Add attachment...";
    return "Afegir Adjunt...";
  case M_REMOVEMARKEDATTACHMENTS:
    //return "Remove marked attachments";
    return "Eliminar Adjunts marcats";
  case M_UPLOADATTACHMENT:
    //return "Upload attachment";
    return "Transmetre Adjunt";
  case M_ADDMARKEDTOATTACHMENTS:
    //return "Add marked to attachments";
    return "Afegir marcats a adjunts";
  case M_UPLOADTOATTACHMENTS:
    //return "Upload to attachments";
    return "Transferir a Adjunts";
  case M_BACKTOCOMPOSE:
    //return "Back to compose";
    return "Tornar a escriure";
  case M_NOATTACHFILES:
    //return "No files";
    return "Sense Fitxers";
  case  M_ATTACHMENTSHEADER:
    // **** 
    return "Cap d'adjunts";
  case M_SENDSAVEFAILED:
    //return "Mail was sent successfully, but save in folder failed.";
    return "El correu ha estat enviar satisfactoriament. Per la gravaci a la bstia ha fallat.";
  case M_SENDNORECV:
    //return "You must specify a recipient of the mail.";
    return "Has d'especificar un destinatari pel correu.";
  case M_DSN_DELAY:
    //return("Report delayed delivery.");
    return "Enviament amb retard d'avs.";
  case M_DSN_SUCCESS:
    // return("Report successful delivery.");
    return "Enviament amb avs.";

  case M_DELETEMARKED:
    //return "Delete marked";
    return "Eliminar els marcats";
  case M_MOVEMARKED:
    //return "Move marked to";
    return "Moure els marcats a";
  case M_SELECTMBOX:
    //return "(Select a mailbox)";
    return "(Seleccioni una bstia)";
  case M_CHECKNEWMAIL:
    //return "Check for new mail";
    return "Comprobar correu nou";
  case M_MAILSHOWN:
    // return sprintf("Mail %d-%d of %d", @arg);
    return sprintf("Miss. %d-%d de %d", @arg);
  case M_BACKN:
    //return sprintf("[<< Prev %d]", @arg);
    return sprintf("[<< Ant. %d]", @arg);
  case M_FORWARDN:
    // return sprintf("[Next %d >>]", @arg);
    return sprintf("[Seg. %d >>]", @arg);
  case M_NUMBER:
    return "#";
  case M_DELETEMARKEDP:
    //sprintf("Are you sure you want to delete the %d marked message(s)?", 
    return 
      sprintf("Est segur de que vol esborrar els %d missatges marcats?", 
	      @arg);
  case M_DELETEMARKEDNONE:
    //return "Please mark some messages first.";
    return "Ha de seleccionar alguns missatges abans.";
  case M_CHANGESORTORDER:
    //return "Change sort order";
    return "Canviar el criteri d'ordenaci";
  case M_MOVETOTRASH:
    //return "Move marked to trash";
    return "Moure els marcats a la paperera";
  case M_DELETEALLTRASH:
    //return "Delete ALL trash";
    return "Eliminar tota la paperera";
  case M_NOMAILS:
    // return "[No mail]";
    return "[Cap Missatge]";
  case M_MARKALL:
    //return "Mark all";
    return "Marcar tots";

  case M_MBOXNAME:
    //return "Mailbox";
    return "Bstia";
  case M_DELETEMARKEDMBOX:
    //return "Delete marked";
    return "Eliminar marcats";
  case M_CREATEMBOX:
    //return "Create a new mailbox";
    return "Crear una nova bstia";
  case M_NEWMBOXNAME:
    //return "(Name)";
    return "(Nom)";
  case M_MBOXREMOVEP:
    //return "Are you sure you want to delete the following mailboxes?";
    return "Esteu segurs de que voleu eliminar les segents bsties?";
  case M_MBOXMARKONE:
    //return "Mark at least one mailbox.";
    return "Marcar com a mnim una bstia.";    
  case M_NEWMBOXNONAME:
    // return "Type in a name first.";
    return "Escrigui primer un nom.";
  case M_CREATEMBOXERROR:
    //return "Failed to create mailbox. The name may be illegal or the mailbox may exist.";
    return "Error al crear la bstia. El nom s incorrecte o ja existeix.";
  case M_INBOX:
    //return "Inbox";
    return "Inbox";
  case M_PREVIOUS_LEVEL:
    //return "[Previous level]";
    return "[Nivell Anterior]";
  case M_FOLDER_PATH:
    //return "Path:";
    return "Cam:";
	
  case M_FILENAME:
    //return "Filename";
    return "Nom de Fitxer";
  case M_SIZE:
    //return "Size";
    return "Mida";
  case M_MIMETYPE:
    //return "Type";
    return "Tipus";
  case M_DELETEMARKEDFILES:
    //return "Delete marked";
    return "Eliminar marcats";
  case M_UPLOAD:
    //return "Upload";
    return "Transferir";
  case M_AVAILSPACE:
    //return sprintf("You have %d Kb available for upload.",@arg);
    return sprintf("Tens %d Kb disponibles per transferncies.",@arg);
  case M_WINDOWSBUG :
    //return "Windowsusers: Due to a bug in some browsers, filenames can be crippled. Avoid this by replacing the last \\ with \\\\ before pressing 'Upload'.";
    return "Usuaris de Windows: Degut a un error present en alguns navegadors els noms de fitxer poden ser alterats.  Es pot evitar reemplaant '\\' per '\\\\'  abans de premer 'Transferir'.";
  case M_NOFILES:
    //return "You have no uploades files.";
    return "No tens fitxers transferits.";

  case M_PNAME:
    //return "Name";
    return "Nom";
  case M_PMAILADDRESS:
    //return "Mail address";
    return "Adrea";
  case M_PMAILPATH:
    //return "Mail searchpath";
    return "Cam de mail";
  case M_PINCLUDEMAIL:
    //return "Include mail when replying";
    return "Incloure missatge al respondre";
  case M_PQUOTEPREFIX :
    //return "Prefix";
    return "Prefixe";
  case M_PSIGNATURE:
    //return "Signature";
    return "Signatura";
  case M_PINACTIVELOGOUT:
    //return "Inactive logout (minutes)";
    return "Sortida per inactivitat (minuts)";
  case M_PSAVEANDUSE:
    //return "Save and use";
    return "Guardar i utilitzar";
  case M_PVISIBLEMESSAGES:
    //return "Messages shown in mailbox";
    return "Missatges mostrats a la bstia";
  case M_PSORTORDER:
    //return "Mail sort order";
    return "Criteri d'ordenaci de correu";
  case M_PSORTORDERS:
    //return ([ "forward": "forward", "backward":"backward"])[arg[0]];
    return ([ "forward": "ascendent", "backward":"descendent"])[arg[0]];
  case M_PTRASHFOLDER:
    //return "Trash folder";
    return "Paperera";
  case M_PSENTFOLDER:
    //return "Sent mail folder";
    return "Correu enviat";
  case M_PDEFAULTBCC:
    //return "Default Bcc address";
    return "Adrea de Bcc per defecte";
  case M_PSAVEATTACHMENTS:
    //return "Save attachments";
    return "Incloure adjunts";
  case M_PLANGUAGE:
    //return "Language";
    return "Idioma";
  case M_PUSERINTERFACE:
    //return "User interface";
    return "Interfcie d'usuari";
  case M_PHEADER:
    //return "Extra headers";
    return "Capaleres extra";
  case M_PHEADERDESC:
    //return "(Lines with headers in this format: header:value )";
    return "(Lnies amb capaleres en aquest format: cap:valor)";

  case M_SPELLDONE:
    //return "Done";
    return "Acabat";
  case M_SPELLPREV:
    //return "Previous";
    return "Anterior";
  case M_SPELLNEXT:
    //return "Next";
    return "Segent";
  case  M_SPELLCHANGETO:
    //return "Change to";
    return "Canviar a";
  case M_SPELLSUGGESTIONS:
    //return "Suggestions";
    return "Suggeriments";

  case M_LOGOUTMSG:
    //return "You are logged out. Close this browser window to make sure no one can read your mail.<br><br>Reload this page to login.";
    return "Esteu desconnectats. Tanqueu aquest navegador per asegurar-vos de que ning no pot llegir el vostre correu.<br><br>Recarregueu la pgina per tornar a entrar.";
  case M_LOGGEDOUT:
    //return "Logged out";
    return "Desconnectats";

  case M_QUESTION:
    //return "Question"; 
    return "Qesti";
  case M_INFO:
    //return "Info"; 
    return "Info";

  case M_REPLY:
    //return "Reply";
    return "Respondre";
  case M_READPREV:
    //return "Read previous";
    return "Llegir anterior";
  case M_READNEXT:
    //return "Read next";
    return "Llegir segent";
  case M_ATTACHMENTLINK:
    //return sprintf("%sattachment of type %s",@arg);
    return sprintf("%sadjunt de tipus %s",@arg);
  case M_MAILMISSING:
    //return "<b>Error:</b> Failed to fetch mail. Try again. <br>";
    return "<b>Error:</b> Problemes al recuperar el correu. Proveu de nou.<br>";
  case M_MAILMISSINGBACK:
    //return "Back";
    return "Enrera";
  case M_DELETE:
    //return "Delete";
    return "Eliminar";
  case M_FORWARD:
    //return "Forward";
    return "Reenviar";
  case M_MAIL:
    // return "Mail";
    return "Correu";
  case M_SHOWFULLHEADERS:
    //return "Show full headers";
    return "Mostrar totes les capaleres";
  case M_HIDEFULLHEADERS:
    //return "Hide full headers";
    return "Amagar totes les capaleres";
  case M_MAILTOOBIG:
    // return "Mail is too big to be shown. Click here to download it.";
    return "El missatge es massa gran per mostrar-lo. Premeu per descarregar-lo.";
  case M_REPLYTOALL:
    //return "Reply to all";
    return "Respondre a tots";
  case M_MOVETHISTOTRASH:
    //return "Move to trash";
    return "Moure a la paperera";
  case M_CHARSETWARNING:
    //return sprintf("Warning! Unable to decode the characterset \"%s\". Message is presented undecoded.",@arg);
    return sprintf("Avs! Imposible decodificar el joc de carcters \"%s\". El missatge es presenta sense decodificat.",@arg);

  case M_ADDRESSBOOKTITLE: 
    //return("Address Book");         
    return("Llibre d'adreces");
  case M_ADDRESSBOOK:
    //return("Address book...");
    return("Llibre d'adreces...");
  case M_INDEXNAMERECIPIENT:
    //return("Intex name (click to add as recipient)");
    return("Nom (Premeu per afegir com a destinatari)");
  case M_INDEXNAMEEDIT:
    //return("Index name (click to edit)");
    return("Nom (Premeu per editar)");
  case M_ADDRESS:
    //return("Address");
    return("Adrea");
  case M_NOADDRESSES:
    //return("No addresses");
    return("Sense adreces");
  case M_NEWADDRESS:
    //return("New address...");
    return("Nova adrea...");
  case M_EDITADDRESS:
    //return("Edit address");
    return("Editar adrea");
  case M_ADDADDRESS:
    //return("Add to address book");
    return("Afegir al llibre d'adreces");
  case M_INDEXNAME:
    //return("Index name");
    return("Nom");
  case M_ADDRESSFORMAT:
    //return("Address(es), comma separated");
    return("Adrea(ces), separades per comes");
  case M_SAVEADDRESS:
    //return("Save and use");
    return("Desar i usar");
  case M_DELETEADDRESS:
    //return("Delete address");
    return("Eliminar adrea");
  case M_CANCELADDRESS:
    //return("Cancel");
    return("Cancellar");
  case M_CANNOTIMPORT:
    //return("Cannot import this addressbook, since its\nformat is not recognized.");
    return("No puc carregar aquest llibre d'adreces, el seu\nformat no es conegut.");
  case M_IMPORTADDRESSBOOKTITLE:
    //return("Import address book");
    return("Importar llibre d'adreces");
  case M_UPLOADADDRESSBOOK:
    //return("Upload a Pine or exported Netscape (.ldif) address book");
    return("Carregar un llibre d'adreces de Pine o un exportat de Netscape (.ldif)");
  case M_PINELOCATION:
    //return("The Pine address book is often in ~/.addressbook");
    return("El llibre d'adreces de pine est sovint a ~/.addressbook");
  case M_UPLOADANDIMPORT:
    //return("Upload and import");
    return("Carregar i importar");
  case M_IMPORTADDRESSBOOK:
    // return("Import address book...");
    return("Importar llibre d'adreces...");
  case M_GLOBALADDRESSES:
    return("Adreces Globals:");

  case M_LDAPTITLE:
    //return("LDAP addresses");
    return("Adreces LDAP");
  case M_LDAP:
    //return("LDAP");
    return("LDAP");
  case M_SEARCHLDAP:
    //return("Search LDAP");
    return("Cercar LDAP");
  case M_NAMECONT:
    //return("Search name containing:");
    return("Buscar un nom que contingui:");
  case M_OU:
    //return("OU");
    return("OU");

  case M_YES:
    //return "Yes";
    return "Si";
  case M_NO:
    //return "No";
    return "No";
  case M_DIALOGOK:
    // return "OK";
    return "OK";
  case M_DIALOGCANCEL:
    // return "Cancel";
    return "Cancellar";
   
  }
  return 0;
}






