(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(** Main module of the cam-config utility *)

let opt_l = "Print the directory of the "^Cam_installation.software^" libraries"
let opt_b = "Print the directory of the "^Cam_installation.software^" executables"
let opt_m = "Print the directory of the "^Cam_installation.software^" man pages"
let opt_t = "Print the directory of the "^Cam_installation.software^" templates"
let opt_p = "Print the directory of the "^Cam_installation.software^" plugins"
let opt_q = "Print the directory of the "^Cam_installation.software^" pixmaps"
let opt_v = "Print the version of "^Cam_installation.software

let usage ="Usage : "^Sys.argv.(0)^" [option] \nwhere option can be one of the following :"

let p s = (fun () ->  print_endline s ; exit 0)

let options = [
  "-l", Arg.Unit (p Cam_installation.lib_dir), opt_l ;
  "-b", Arg.Unit (p Cam_installation.bin_dir), opt_b ;
  "-m", Arg.Unit (p Cam_installation.man_dir), opt_m ;
  "-t", Arg.Unit (p Cam_installation.templates_dir), opt_t ;
  "-p", Arg.Unit (p Cam_installation.plugins_dir), opt_p ;
  "-q", Arg.Unit (p Cam_installation.pixmaps_dir), opt_q ;
  "-v", Arg.Unit (p Cam_installation.software_version), opt_v ;
] 

let _ = Arg.parse options
    (fun _ -> ())
    usage
