(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(** Global values and hooks *)

(** The menus. *)
val menus : Cam_menus.menu list ref

(** The registered commands. *)
val commands : (Cam_menus.command, string * (string list -> unit)) Hashtbl.t

(** [add_command com desc f] adds the command [com] to the list of
   registered commands, with description [desc] and callback [f].
   The callback takes a list of arguments in parameter.
   If the same command exists in the table, it is hidden by the new one.
*)
val add_command : Cam_menus.command -> string -> (string list -> unit) -> unit

(** Return the list of the available commands. *)
val available_commands : unit -> Cam_menus.command list

(** Return the list of the available commands, with their description. *)
val available_commands_with_help : unit -> (Cam_menus.command * string) list

(** [exec com args ()] execute the function associated to the command [com]
   with the given list of arguments.
   Catch all the exceptions raised by the function. Does nothing if
   there is no function associated to the command.*)
val exec : Cam_menus.command -> string list -> unit -> unit

(** The selected directory (its name as it appears in the tree, absolute or relative).*)
val selected_dir : (unit -> string option) ref 

(** The selected files. *)
val selected_files : (unit -> Cam_types.file list) ref

(** The custom editors (id, function to create an instance of the editor). *)
val custom_editors : 
    (string * (?char: int -> Cam_types.file -> Cam_types.editor_app option)) list ref

(** [add_embedded_app com f] registers an application which can be started
   by command [com]. When this command is triggered, [f ()] is evaluated to
   get an application object. *)
val add_embedded_app : Cam_menus.command -> (unit -> Cam_embed.embedded_app) -> unit

(** The registered functions to get config boxes, in addition
   to the default ones. *)
val config_boxes : (unit -> Configwin.configuration_structure) list ref

(** Add a function to the functions defining a section of the configuration
   window. *)
val add_config_box : (unit -> Configwin.configuration_structure) -> unit

(** The list of views. *)
val views : Cam_view.view list ref

(** A hook, set in module {!Cam}, to pack a view in the notebook. *)
val pack_view : (Cam_view.view -> string -> unit) ref

(** Add a view to the list of views. *)
val add_view : Cam_view.view -> string -> unit

(** Display a message in the label at the bottom of the main window. 
   Initiliazed in Cam_gui.*)
val display_message : (string -> unit) ref
