(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(** Creation of the main window *)

module M = Cam_messages

let window = GWindow.window ~title: M.software
    ~width: 900 ~height: 500 ()
let _ = window#connect#destroy GMain.Main.quit

let vbox = GPack.vbox ~packing: window#add ()

let menubar = GMenu.menu_bar 
    ~packing: (vbox#pack ~expand: false) 
    ()

(* Tool bar *)

let handle_box = GBin.handle_box
    ~handle_position: `LEFT
    ~packing: (vbox#pack ~expand: false) ()

let hbox = GPack.hbox ~packing: (vbox#pack ~expand: true) ()

let wpane = GPack.paned `HORIZONTAL
    ~packing: (hbox#pack ~expand: true) ()

let wnote = GPack.notebook ~packing: wpane#add2 ()

let pack_view v l =
  let wl = GMisc.label ~text: l () in
  wnote#insert_page ~pos: 0 ~tab_label: wl#coerce v#coerce

let _ = Cam_global.pack_view := pack_view

let vbox_tree = GPack.vbox ~width: 160 ~packing: wpane#add1 ()

let _ = wnote#connect#switch_page 
    ~callback: 
      (fun page -> 
	try (List.nth !Cam_global.views page)#display_dir 
	    (!Cam_global.selected_dir ())
	with _ -> ()
      )

let wl_message = GMisc.label ~text: Cam_messages.welcome 
    ~xalign: (- 0.95)
    ~packing: (vbox#pack ~fill: true ~expand: false ~padding: 3) ()

let display_message s =
  wl_message#set_text s;
  while Glib.Main.pending () do
    ignore (Glib.Main.iteration false)
  done

let _ = Cam_global.display_message := display_message
