(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(** Main module of the standalone tool. *)

ignore (GMain.Main.init ());;

(** {2 Main} *)

let _ = Sys.signal Sys.sigpipe Sys.Signal_ignore

let main () =
  Chat_messages.verbose "main ()";
  let socket_server = Chat_com.open_server () in
  Chat_messages.verbose "socket server ok";
  let app = new Chat_app.app socket_server in
  Chat_messages.verbose "app ok";
  let window = GWindow.window 
      ~allow_shrink: true
      ~allow_grow: true
      ~width: 330 ~height: 240
      ~title: Chat_messages.software () 
  in
  prerr_endline "window ok";
  window#add app#coerce ;
  ignore (app#box#connect#destroy window#destroy);
  ignore (window#connect#destroy GMain.Main.quit);
  app#init_window window ;
  window#show () ;
  GtkThread.main ();
  app#close ;
  Unix.close socket_server
      
let _ = Unix.handle_unix_error main ()
