(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(** Example *)

let _ = GMain.Main.init ()

class gui ?(largeur=3) files =
  object (self)
    (** inherit from base class defining the widgets *)
    inherit Example_base.gui ()

    method click_b1 () = 
      prerr_endline "click on button 1"

    method click_b2 () = 
      prerr_endline "click on button 2"

    initializer
      let i = ref 0 in
      let j = ref 0 in
      let rec iter = function
	  [] -> 
	    ()
	| f :: q ->
	    (try 
	      let gdk_pix = 
		GDraw.pixmap_from_xpm ~file: f
		  ~colormap: (Gdk.Color.get_system_colormap ())
		  () 
	      in
	      let pix = GMisc.pixmap gdk_pix () in
	      wtable#attach ~left: (!i mod largeur) ~top: (!j / largeur) pix#coerce;
	      incr i;
	      incr j;
	    with
	      _ -> ()
	    );
	    iter q
      in
      iter files;

      ignore (wb_one#connect#clicked self#click_b1);
      ignore (wb_two#connect#clicked self#click_b2)
  end

let files =
  match Array.to_list Sys.argv with
    [] | [_] ->
      prerr_endline (Printf.sprintf "usage %s <file1.xpm> <file2.xpm> ..."
		       Sys.argv.(1));
      exit 1
  | l -> l

let gui = new gui ~largeur: 12 files
let _ = gui#window#connect#destroy GMain.Main.quit
let _ = gui#itemQuit#connect#activate gui#window#destroy
let _ = gui#window#show ()
let _ = gui#window#add_accel_group gui#accelgroup
let _ = GMain.Main.main ()
